/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchQueryHeaderQueryGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchQuery.HeaderQuery> {

	public SearchQueryHeaderQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchQuery.HeaderQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchQuery.HeaderQuery ret = new net.bluemind.backend.mail.api.SearchQuery.HeaderQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchQuery.HeaderQuery ret, JSONObject json) {
		JSONValue logicalOperatorJSON = json.get("logicalOperator");
		ret.logicalOperator =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().deserialize(logicalOperatorJSON);
		JSONValue queryJSON = json.get("query");
		ret.query =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderGwtSerDer()).deserialize(queryJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchQuery.HeaderQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("logicalOperator")) {
			JSONValue logicalOperatorJSON = json.get("logicalOperator");
			ret.logicalOperator =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().deserialize(logicalOperatorJSON);
		}
		if (!childPropertiesToIgnore.contains("query")) {
			JSONValue queryJSON = json.get("query");
			ret.query =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderGwtSerDer()).deserialize(queryJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchQuery.HeaderQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchQuery.HeaderQuery o, JSONObject ret) {

		ret.put("logicalOperator",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().serialize( o.logicalOperator ));
		ret.put("query",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderGwtSerDer()).serialize( o.query ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchQuery.HeaderQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("logicalOperator")) {
			ret.put("logicalOperator",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().serialize( o.logicalOperator ));
		}
		if (!childPropertiesToIgnore.contains("query")) {
			ret.put("query",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderGwtSerDer()).serialize( o.query ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}