/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageBodyHeaderGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageBody.Header> {

	public MessageBodyHeaderGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageBody.Header deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageBody.Header ret = new net.bluemind.backend.mail.api.MessageBody.Header();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Header ret, JSONObject json) {
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue valuesJSON = json.get("values");
		ret.values =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(valuesJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Header ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("values")) {
			JSONValue valuesJSON = json.get("values");
			ret.values =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(valuesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageBody.Header o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Header o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("values",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.values ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Header o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("values")) {
			ret.put("values",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.values ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}