/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.backend.mail.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMessageBody extends JavaScriptObject {

	protected JsMessageBody() {}

	public final native String getGuid()
	/*-{
	return this["guid"];
	}-*/;

	public final native void setGuid(String guid)
	/*-{
       this["guid"] = guid;
	}-*/;

	public final native String getSubject()
	/*-{
	return this["subject"];
	}-*/;

	public final native void setSubject(String subject)
	/*-{
       this["subject"] = subject;
	}-*/;

	public final native boolean getSmartAttach()
	/*-{
	return this["smartAttach"];
	}-*/;

	public final native void setSmartAttach(boolean smartAttach)
	/*-{
       this["smartAttach"] = smartAttach;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getDate()
	/*-{
       if(this["date"]) {
          return new Date(this["date"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setDate(com.google.gwt.core.client.JsDate date)
	/*-{
       this["date"] =  ( date != null) ? date.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getCreated()
	/*-{
       if(this["created"]) {
          return new Date(this["created"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setCreated(com.google.gwt.core.client.JsDate created)
	/*-{
       this["created"] =  ( created != null) ? created.getTime() : null;
	}-*/;

	public final native int getSize()
	/*-{
	return this["size"];
	}-*/;

	public final native void setSize(int size)
	/*-{
       this["size"] = size;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.backend.mail.api.gwt.js.JsMessageBodyHeader> getHeaders()
	/*-{
	return this["headers"];
	}-*/;

	public final native void setHeaders(com.google.gwt.core.client.JsArray<net.bluemind.backend.mail.api.gwt.js.JsMessageBodyHeader> headers)
	/*-{
       this["headers"] = headers;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.backend.mail.api.gwt.js.JsMessageBodyRecipient> getRecipients()
	/*-{
	return this["recipients"];
	}-*/;

	public final native void setRecipients(com.google.gwt.core.client.JsArray<net.bluemind.backend.mail.api.gwt.js.JsMessageBodyRecipient> recipients)
	/*-{
       this["recipients"] = recipients;
	}-*/;

	public final native String getMessageId()
	/*-{
	return this["messageId"];
	}-*/;

	public final native void setMessageId(String messageId)
	/*-{
       this["messageId"] = messageId;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayString getReferences()
	/*-{
	return this["references"];
	}-*/;

	public final native void setReferences(com.google.gwt.core.client.JsArrayString references)
	/*-{
       this["references"] = references;
	}-*/;

	public final native net.bluemind.backend.mail.api.gwt.js.JsMessageBodyPart getStructure()
	/*-{
	return this["structure"];
	}-*/;

	public final native void setStructure(net.bluemind.backend.mail.api.gwt.js.JsMessageBodyPart structure)
	/*-{
       this["structure"] = structure;
	}-*/;

	public final native String getPreview()
	/*-{
	return this["preview"];
	}-*/;

	public final native void setPreview(String preview)
	/*-{
       this["preview"] = preview;
	}-*/;

	public final native int getBodyVersion()
	/*-{
	return this["bodyVersion"];
	}-*/;

	public final native void setBodyVersion(int bodyVersion)
	/*-{
       this["bodyVersion"] = bodyVersion;
	}-*/;

	public static native  JsMessageBody create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}