/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class MailFinderGwtEndpoint implements net.bluemind.backend.mail.api.IMailFinderAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public MailFinderGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_finder/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public MailFinderGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void search(net.bluemind.backend.mail.api.MailFinderQuery query, final AsyncHandler<net.bluemind.backend.mail.api.SearchResult> handler) {
		String postUri = "/_search/";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.backend.mail.api.gwt.serder.MailFinderQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.backend.mail.api.SearchResult>(handler) {
			@Override
			protected net.bluemind.backend.mail.api.SearchResult handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.backend.mail.api.gwt.serder.SearchResultGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.backend.mail.api.IMailFinderPromise promiseApi() {
		return new MailFinderEndpointPromise(this);
	}
}
