/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.monitoring.screens;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.handler.DefaultAsyncHandler;
import net.bluemind.system.api.hot.upgrade.HotUpgradeProgress;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus;
import net.bluemind.system.api.hot.upgrade.IHotUpgradePromise;
import net.bluemind.system.api.hot.upgrade.gwt.endpoint.HotUpgradeGwtEndpoint;
import net.bluemind.ui.adminconsole.monitoring.l10n.ScreensConstants;
import net.bluemind.ui.adminconsole.monitoring.screens.HotUpgradeTasksGrid;
import net.bluemind.ui.common.client.forms.Ajax;

public class HotUpgradeStatusScreen
extends Composite
implements IGwtScreenRoot {
    public ScreensConstants text;
    public static final String TYPE = "bm.ac.HotUpgradeStatusScreen";
    private ScreenRoot screenRoot;
    private final Style s;
    @UiField
    HotUpgradeTasksGrid running;
    @UiField
    HotUpgradeTasksGrid planned;
    @UiField
    HotUpgradeTasksGrid finished;
    @UiField
    Label info;
    @UiField
    TabLayoutPanel tabContainer;
    private static HotUpgradeStatusScreenBinder uiBinder = (HotUpgradeStatusScreenBinder)GWT.create(HotUpgradeStatusScreenBinder.class);
    private static final Resources res = (Resources)GWT.create(Resources.class);

    private HotUpgradeStatusScreen(ScreenRoot screenRoot) {
        this.screenRoot = screenRoot;
        this.s = res.editStyle();
        this.s.ensureInjected();
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        hTMLPanel.setHeight("100%");
        this.initWidget((Widget)hTMLPanel);
        this.text = (ScreensConstants)GWT.create(ScreensConstants.class);
    }

    public static void registerType() {
        GwtScreenRoot.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtScreenRoot, ScreenRoot>(){

            public IGwtScreenRoot create(ScreenRoot screenRoot) {
                return new HotUpgradeStatusScreen(screenRoot);
            }
        });
    }

    public void attach(Element element) {
        element.appendChild((Node)this.getElement());
        this.onAttach();
    }

    public void doLoad(final ScreenRoot screenRoot) {
        screenRoot.load((AsyncHandler)new DefaultAsyncHandler<Void>(){

            public void success(Void void_) {
                screenRoot.loadModel(screenRoot.getModel());
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        IHotUpgradePromise iHotUpgradePromise = new HotUpgradeGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).promiseApi();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ((CompletableFuture)iHotUpgradePromise.progress().thenAccept(list -> {
            if (list.isEmpty()) {
                this.info.setText("No hot upgrade tasks in database (planned, successfull or failed");
            }
            for (HotUpgradeProgress hotUpgradeProgress : list) {
                this.info.setText(String.valueOf(hotUpgradeProgress.status) + ": " + hotUpgradeProgress.count + " task(s) (last updated at: " + HotUpgradeTasksGrid.sdf.format(hotUpgradeProgress.lastUpdatedAt) + ")");
            }
        })).thenAccept(void_2 -> {
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)iHotUpgradePromise.running().thenAccept(set -> {
                boolean bl = arrayList.addAll(set);
            })).thenCompose(void_ -> iHotUpgradePromise.list(HotUpgradeTaskFilter.filter((HotUpgradeTaskStatus[])new HotUpgradeTaskStatus[]{HotUpgradeTaskStatus.PLANNED})))).thenCompose(list2 -> {
                arrayList2.addAll(list2);
                return iHotUpgradePromise.list(HotUpgradeTaskFilter.filter((HotUpgradeTaskStatus[])new HotUpgradeTaskStatus[]{HotUpgradeTaskStatus.SUCCESS, HotUpgradeTaskStatus.FAILURE}));
            })).thenAccept(list2 -> {
                arrayList3.addAll(list2);
                Collections.sort(arrayList3, (hotUpgradeTask, hotUpgradeTask2) -> Long.compare(hotUpgradeTask2.updatedAt.getTime(), hotUpgradeTask.updatedAt.getTime()));
            })).thenAccept(void_ -> {
                this.tabContainer.addSelectionHandler(selectionEvent -> {
                    switch ((Integer)selectionEvent.getSelectedItem()) {
                        case 0: {
                            this.running.setValues(arrayList);
                            break;
                        }
                        case 1: {
                            this.planned.setValues(arrayList2);
                            break;
                        }
                        case 2: {
                            this.finished.setValues(arrayList3);
                        }
                    }
                });
                this.tabContainer.selectTab(0);
            });
        });
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
    }

    static interface HotUpgradeStatusScreenBinder
    extends UiBinder<HTMLPanel, HotUpgradeStatusScreen> {
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"HotUpgradeStatusScreen.css"})
        public Style editStyle();
    }

    public static interface Style
    extends CssResource {
    }
}

