/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.ldap.importation.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class LdapImportSockJsEndpoint implements net.bluemind.system.ldap.importation.api.ILdapImportAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public LdapImportSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/ldapimport";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public LdapImportSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void fullSync(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/_fullsync";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void testParameters(String hostname, String protocol, String allCertificate, String basedn, String logindn, String password, String userfilter, String groupfilter, final AsyncHandler<Void> handler) {
		String postUri = "/_testparameters";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("hostname", URL.encodeQueryString(""+hostname));
		params.put("protocol", URL.encodeQueryString(""+protocol));
		params.put("allCertificate", URL.encodeQueryString(""+allCertificate));
		params.put("basedn", URL.encodeQueryString(""+basedn));
		params.put("logindn", URL.encodeQueryString(""+logindn));
		params.put("password", URL.encodeQueryString(""+password));
		params.put("userfilter", URL.encodeQueryString(""+userfilter));
		params.put("groupfilter", URL.encodeQueryString(""+groupfilter));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.system.ldap.importation.api.ILdapImportPromise promiseApi() {
		return new LdapImportEndpointPromise(this);
	}

}
