/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final record DataLocation(String serverUid) {

	private static final DataLocation DIR = new DataLocation(null);
	private static final Map<String, DataLocation> byServer = new ConcurrentHashMap<>();

	public static DataLocation directory() {
		return DIR;
	}

	/**
	 * @param serverUidOrNull
	 * @return de-duplicated {@link DataLocation} instance
	 */
	public static DataLocation of(String serverUidOrNull) {
		return serverUidOrNull == null ? DIR : byServer.computeIfAbsent(serverUidOrNull, DataLocation::new);
	}

}
