/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptionsConverter;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class SockJSBridgeOptions
extends BridgeOptions {
    public static final int DEFAULT_MAX_ADDRESS_LENGTH = 200;
    public static final int DEFAULT_MAX_HANDLERS_PER_SOCKET = 1000;
    public static final long DEFAULT_PING_TIMEOUT = 10000L;
    public static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private int maxAddressLength;
    private int maxHandlersPerSocket;
    private long pingTimeout;
    private long replyTimeout;

    public SockJSBridgeOptions(SockJSBridgeOptions other) {
        super(other);
        this.maxAddressLength = other.maxAddressLength;
        this.maxHandlersPerSocket = other.maxHandlersPerSocket;
        this.pingTimeout = other.pingTimeout;
        this.replyTimeout = other.replyTimeout;
    }

    public SockJSBridgeOptions() {
        this.maxAddressLength = 200;
        this.maxHandlersPerSocket = 1000;
        this.pingTimeout = 10000L;
        this.replyTimeout = 30000L;
    }

    public SockJSBridgeOptions(JsonObject json) {
        this();
        SockJSBridgeOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public int getMaxAddressLength() {
        return this.maxAddressLength;
    }

    public SockJSBridgeOptions setMaxAddressLength(int maxAddressLength) {
        if (maxAddressLength < 1) {
            throw new IllegalArgumentException("maxAddressLength must be > 0");
        }
        this.maxAddressLength = maxAddressLength;
        return this;
    }

    public int getMaxHandlersPerSocket() {
        return this.maxHandlersPerSocket;
    }

    public SockJSBridgeOptions setMaxHandlersPerSocket(int maxHandlersPerSocket) {
        if (maxHandlersPerSocket < 1) {
            throw new IllegalArgumentException("maxHandlersPerSocket must be > 0");
        }
        this.maxHandlersPerSocket = maxHandlersPerSocket;
        return this;
    }

    public long getPingTimeout() {
        return this.pingTimeout;
    }

    public SockJSBridgeOptions setPingTimeout(long pingTimeout) {
        if (pingTimeout < 1L) {
            throw new IllegalArgumentException("pingTimeout must be > 0");
        }
        this.pingTimeout = pingTimeout;
        return this;
    }

    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    public SockJSBridgeOptions setReplyTimeout(long replyTimeout) {
        if (replyTimeout < 1L) {
            throw new IllegalArgumentException("replyTimeout must be > 0");
        }
        this.replyTimeout = replyTimeout;
        return this;
    }

    @Override
    public SockJSBridgeOptions addInboundPermitted(PermittedOptions permitted) {
        super.addInboundPermitted(permitted);
        return this;
    }

    @Override
    public SockJSBridgeOptions setInboundPermitteds(List<PermittedOptions> inboundPermitted) {
        super.setInboundPermitteds(inboundPermitted);
        return this;
    }

    @Override
    public SockJSBridgeOptions addOutboundPermitted(PermittedOptions permitted) {
        super.addOutboundPermitted(permitted);
        return this;
    }

    @Override
    public SockJSBridgeOptions setOutboundPermitteds(List<PermittedOptions> outboundPermitted) {
        super.setOutboundPermitteds(outboundPermitted);
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        SockJSBridgeOptionsConverter.toJson(this, json);
        return json;
    }
}

