package net.bluemind.keydb.common.topology.bm;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.config.BmIni;
import net.bluemind.keydb.common.IKeydbBootstrap;

public class KeydbInCoreResolver implements IKeydbBootstrap {
	private static final Logger logger = LoggerFactory.getLogger(KeydbInCoreResolver.class);

	@Override
	public String keydbHost() {
		Optional<String> optAddress = Optional.ofNullable(BmIni.value("redis-bootstrap-address"))
				.or(() -> Optional.ofNullable(BmIni.value("hz-member-address")))
				.or(() -> Optional.ofNullable("localhost"));

		logger.info("Found keydb address '{}'", optAddress.get());
		return optAddress.get();
	}

}
