/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.lifecycle.helper;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftReset {

	private static final Logger logger = LoggerFactory.getLogger(SoftReset.class);

	private static final AtomicLong generation = new AtomicLong();

	private SoftReset() {

	}

	private static final Set<ISoftResetHandler> handlers = ConcurrentHashMap.newKeySet();

	public static final void register(ISoftResetHandler handler) {
		handlers.add(handler);
	}

	public static long activeGen() {
		return generation.get();
	}

	public static void trigger() {
		long nextGen = generation.incrementAndGet();
		logger.info("==== SoftReset with {} handler(s), generation is now {} ====", handlers.size(), nextGen);
		handlers.forEach(ISoftResetHandler::onSoftReset);
	}

}
