/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.SegmentedDatagramPacket;
import io.netty.channel.unix.Socket;
import io.netty.incubator.channel.uring.AbstractIOUringChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringDatagramChannelConfig;
import io.netty.incubator.channel.uring.IOUringRecvByteAllocatorHandle;
import io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import io.netty.incubator.channel.uring.LinuxSocket;
import io.netty.incubator.channel.uring.MsgHdrMemory;
import io.netty.incubator.channel.uring.MsgHdrMemoryArray;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;

public final class IOUringDatagramChannel
extends AbstractIOUringChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final IOUringDatagramChannelConfig config = new IOUringDatagramChannelConfig(this);
    private volatile boolean connected;

    public IOUringDatagramChannel() {
        this((InternetProtocolFamily)null);
    }

    public IOUringDatagramChannel(InternetProtocolFamily family) {
        this(family == null ? LinuxSocket.newSocketDgram(Socket.isIPv6Preferred()) : LinuxSocket.newSocketDgram(family == InternetProtocolFamily.IPv6), false);
    }

    public IOUringDatagramChannel(int fd) {
        this(new LinuxSocket(fd), true);
    }

    private IOUringDatagramChannel(LinuxSocket fd, boolean active) {
        super(null, fd, active);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress) {
        return this.joinGroup(multicastAddress, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.joinGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            promise.setFailure(e);
            return promise;
        }
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.joinGroup(multicastAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        return this.joinGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.joinGroup(multicastAddress, networkInterface, source, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull(multicastAddress, "multicastAddress");
        ObjectUtil.checkNotNull(networkInterface, "networkInterface");
        try {
            this.socket.joinGroup(multicastAddress, networkInterface, source);
            promise.setSuccess();
        }
        catch (IOException e) {
            promise.setFailure(e);
        }
        return promise;
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress) {
        return this.leaveGroup(multicastAddress, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            promise.setFailure(e);
            return promise;
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(multicastAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        return this.leaveGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.leaveGroup(multicastAddress, networkInterface, source, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull(multicastAddress, "multicastAddress");
        ObjectUtil.checkNotNull(networkInterface, "networkInterface");
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface, source);
            promise.setSuccess();
        }
        catch (IOException e) {
            promise.setFailure(e);
        }
        return promise;
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        return this.block(multicastAddress, networkInterface, sourceToBlock, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        ObjectUtil.checkNotNull(multicastAddress, "multicastAddress");
        ObjectUtil.checkNotNull(sourceToBlock, "sourceToBlock");
        ObjectUtil.checkNotNull(networkInterface, "networkInterface");
        promise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return promise;
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        return this.block(multicastAddress, sourceToBlock, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        try {
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), sourceToBlock, promise);
        }
        catch (Throwable e) {
            promise.setFailure(e);
            return promise;
        }
    }

    @Override
    protected AbstractIOUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IOUringDatagramChannelUnsafe();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress socketAddress;
        if (localAddress instanceof InetSocketAddress && (socketAddress = (InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && socketAddress.getAddress() instanceof Inet4Address && this.socket.family() == InternetProtocolFamily.IPv6) {
            localAddress = new InetSocketAddress(LinuxSocket.INET6_ANY, socketAddress.getPort());
        }
        super.doBind(localAddress);
        this.active = true;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)envelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            IOUringDatagramChannel.checkUnresolved(packet);
            ByteBuf content = (ByteBuf)packet.content();
            return !content.hasMemoryAddress() ? packet.replace(this.newDirectBuffer(packet, content)) : msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            return !buf.hasMemoryAddress() ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope<ByteBuf, InetSocketAddress> e = (AddressedEnvelope<ByteBuf, InetSocketAddress>)msg;
            IOUringDatagramChannel.checkUnresolved(e);
            if (e.content() instanceof ByteBuf && (e.recipient() == null || e.recipient() instanceof InetSocketAddress)) {
                ByteBuf content = (ByteBuf)e.content();
                return !content.hasMemoryAddress() ? new DefaultAddressedEnvelope<ByteBuf, InetSocketAddress>(this.newDirectBuffer(e, content), (InetSocketAddress)e.recipient()) : e;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    @Override
    public IOUringDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        ((IOUringDatagramChannelUnsafe)this.unsafe()).releaseBuffers();
        this.connected = false;
    }

    private static IOException translateForConnected(Errors.NativeIoException e) {
        if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            PortUnreachableException error = new PortUnreachableException(e.getMessage());
            error.initCause(e);
            return error;
        }
        return e;
    }

    public static boolean isSegmentedDatagramPacketSupported() {
        return IOUring.isAvailable();
    }

    final class IOUringDatagramChannelUnsafe
    extends AbstractIOUringChannel.AbstractUringUnsafe {
        private final MsgHdrMemoryArray recvmsgHdrs = new MsgHdrMemoryArray(256);
        private final MsgHdrMemoryArray sendmsgHdrs = new MsgHdrMemoryArray(256);
        private final int[] sendmsgResArray = new int[this.sendmsgHdrs.capacity()];
        private final WriteProcessor writeProcessor = new WriteProcessor();
        private ByteBuf readBuffer;

        IOUringDatagramChannelUnsafe() {
        }

        void releaseBuffers() {
            this.sendmsgHdrs.release();
            this.recvmsgHdrs.release();
        }

        @Override
        protected void readComplete0(int res, int data, int outstanding) {
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = IOUringDatagramChannel.this.pipeline();
            ByteBuf byteBuf = this.readBuffer;
            assert (byteBuf != null);
            try {
                if (data == -1) {
                    assert (outstanding == 0);
                    this.readComplete(pipeline, allocHandle, byteBuf, res);
                } else {
                    this.recvmsgComplete(pipeline, allocHandle, byteBuf, res, data, outstanding);
                }
            }
            catch (Throwable t2) {
                IOException t2;
                if (IOUringDatagramChannel.this.connected && t2 instanceof Errors.NativeIoException) {
                    t2 = IOUringDatagramChannel.translateForConnected((Errors.NativeIoException)t2);
                }
                pipeline.fireExceptionCaught(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComplete(ChannelPipeline pipeline, IOUringRecvByteAllocatorHandle allocHandle, ByteBuf byteBuf, int res) throws IOException {
            try {
                this.readBuffer = null;
                if (res < 0) {
                    allocHandle.lastBytesRead(Errors.ioResult("io_uring read", res));
                } else if (res > 0) {
                    byteBuf.writerIndex(byteBuf.writerIndex() + res);
                    allocHandle.lastBytesRead(res);
                } else {
                    allocHandle.lastBytesRead(-1);
                }
                if (allocHandle.lastBytesRead() <= 0) {
                    byteBuf.release();
                    byteBuf = null;
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    return;
                }
                allocHandle.incMessagesRead(1);
                pipeline.fireChannelRead(new DatagramPacket(byteBuf, IOUringDatagramChannel.this.localAddress(), IOUringDatagramChannel.this.remoteAddress()));
                byteBuf = null;
                if (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER)) {
                    this.scheduleRead();
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }

        private void recvmsgComplete(ChannelPipeline pipeline, IOUringRecvByteAllocatorHandle allocHandle, ByteBuf byteBuf, int res, int idx, int outstanding) throws IOException {
            MsgHdrMemory hdr = this.recvmsgHdrs.hdr(idx);
            if (res < 0) {
                allocHandle.lastBytesRead(Errors.ioResult("io_uring recvmsg", res));
            } else {
                allocHandle.lastBytesRead(res);
                if (hdr.hasPort(IOUringDatagramChannel.this)) {
                    allocHandle.incMessagesRead(1);
                    DatagramPacket packet = hdr.read(IOUringDatagramChannel.this, byteBuf, res);
                    pipeline.fireChannelRead(packet);
                }
            }
            if (outstanding == 0) {
                this.readBuffer.release();
                this.readBuffer = null;
                this.recvmsgHdrs.clear();
                if (allocHandle.lastBytesRead() > 0 && allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER)) {
                    this.scheduleRead();
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
            }
        }

        @Override
        protected int scheduleRead0() {
            int numDatagram;
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ByteBuf byteBuf = allocHandle.allocate(IOUringDatagramChannel.this.alloc());
            assert (this.readBuffer == null);
            this.readBuffer = byteBuf;
            int writable = byteBuf.writableBytes();
            allocHandle.attemptedBytesRead(writable);
            int datagramSize = IOUringDatagramChannel.this.config().getMaxDatagramPayloadSize();
            int n = numDatagram = datagramSize == 0 ? 1 : Math.max(1, byteBuf.writableBytes() / datagramSize);
            if (IOUringDatagramChannel.this.isConnected() && numDatagram <= 1) {
                IOUringDatagramChannel.this.submissionQueue().addRecv(IOUringDatagramChannel.this.socket.intValue(), byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity(), (short)-1);
                return 1;
            }
            int scheduled = this.scheduleRecvmsg(byteBuf, numDatagram, datagramSize);
            if (scheduled == 0) {
                this.readBuffer = null;
                byteBuf.release();
            }
            return scheduled;
        }

        private int scheduleRecvmsg(ByteBuf byteBuf, int numDatagram, int datagramSize) {
            int i;
            int writable = byteBuf.writableBytes();
            IOUringSubmissionQueue submissionQueue = IOUringDatagramChannel.this.submissionQueue();
            long bufferAddress = byteBuf.memoryAddress() + (long)byteBuf.writerIndex();
            if (numDatagram <= 1) {
                return this.scheduleRecvmsg0(submissionQueue, bufferAddress, writable) ? 1 : 0;
            }
            for (i = 0; i < numDatagram && writable >= datagramSize && this.scheduleRecvmsg0(submissionQueue, bufferAddress, datagramSize); writable -= datagramSize, ++i) {
                bufferAddress += (long)datagramSize;
            }
            return i;
        }

        private boolean scheduleRecvmsg0(IOUringSubmissionQueue submissionQueue, long bufferAddress, int bufferLength) {
            MsgHdrMemory msgHdrMemory = this.recvmsgHdrs.nextHdr();
            if (msgHdrMemory == null) {
                return false;
            }
            msgHdrMemory.write(IOUringDatagramChannel.this.socket, null, bufferAddress, bufferLength, (short)0);
            submissionQueue.addRecvmsg(IOUringDatagramChannel.this.socket.intValue(), msgHdrMemory.address(), (short)msgHdrMemory.idx());
            return true;
        }

        @Override
        boolean writeComplete0(int res, int data, int outstanding) {
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer();
            if (data == -1) {
                assert (outstanding == 0);
                return this.removeFromOutboundBuffer(outboundBuffer, res, "io_uring write");
            }
            this.sendmsgResArray[data] = res;
            if (outstanding == 0) {
                boolean writtenSomething = false;
                int numWritten = this.sendmsgHdrs.length();
                this.sendmsgHdrs.clear();
                for (int i = 0; i < numWritten; ++i) {
                    writtenSomething |= this.removeFromOutboundBuffer(outboundBuffer, this.sendmsgResArray[i], "io_uring sendmsg");
                }
                return writtenSomething;
            }
            return true;
        }

        private boolean removeFromOutboundBuffer(ChannelOutboundBuffer outboundBuffer, int res, String errormsg) {
            if (res >= 0) {
                return outboundBuffer.remove();
            }
            try {
                return Errors.ioResult(errormsg, res) != 0;
            }
            catch (Throwable cause) {
                return outboundBuffer.remove(cause);
            }
        }

        @Override
        void connectComplete(int res) {
            if (res >= 0) {
                IOUringDatagramChannel.this.connected = true;
            }
            super.connectComplete(res);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            return this.writeProcessor.write(in);
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            return this.scheduleWrite(msg, false) ? 1 : 0;
        }

        private boolean scheduleWrite(Object msg, boolean forceSendmsg) {
            int segmentSize;
            InetSocketAddress remoteAddress;
            ByteBuf data;
            if (msg instanceof AddressedEnvelope) {
                AddressedEnvelope envelope = (AddressedEnvelope)msg;
                data = (ByteBuf)envelope.content();
                remoteAddress = (InetSocketAddress)envelope.recipient();
                segmentSize = msg instanceof SegmentedDatagramPacket ? ((SegmentedDatagramPacket)msg).segmentSize() : 0;
            } else {
                data = (ByteBuf)msg;
                remoteAddress = null;
                segmentSize = 0;
            }
            long bufferAddress = data.memoryAddress();
            IOUringSubmissionQueue submissionQueue = IOUringDatagramChannel.this.submissionQueue();
            if (remoteAddress == null) {
                if (forceSendmsg || segmentSize > 0) {
                    return this.scheduleSendmsg(IOUringDatagramChannel.this.remoteAddress(), bufferAddress, data.readableBytes(), segmentSize);
                }
                submissionQueue.addSend(IOUringDatagramChannel.this.socket.intValue(), bufferAddress, data.readerIndex(), data.writerIndex(), (short)-1);
                return true;
            }
            return this.scheduleSendmsg(remoteAddress, bufferAddress, data.readableBytes(), segmentSize);
        }

        private boolean scheduleSendmsg(InetSocketAddress remoteAddress, long bufferAddress, int bufferLength, int segmentSize) {
            MsgHdrMemory hdr = this.sendmsgHdrs.nextHdr();
            if (hdr == null) {
                return false;
            }
            hdr.write(IOUringDatagramChannel.this.socket, remoteAddress, bufferAddress, bufferLength, (short)segmentSize);
            IOUringDatagramChannel.this.submissionQueue().addSendmsg(IOUringDatagramChannel.this.socket.intValue(), hdr.address(), (short)hdr.idx());
            return true;
        }

        private final class WriteProcessor
        implements ChannelOutboundBuffer.MessageProcessor {
            private int written;

            private WriteProcessor() {
            }

            @Override
            public boolean processMessage(Object msg) {
                if (IOUringDatagramChannelUnsafe.this.scheduleWrite(msg, true)) {
                    ++this.written;
                    return true;
                }
                return false;
            }

            int write(ChannelOutboundBuffer in) {
                this.written = 0;
                try {
                    in.forEachFlushedMessage(this);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                return this.written;
            }
        }
    }
}

