/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class DirEntryMaintenanceGwtEndpoint implements net.bluemind.directory.api.IDirEntryMaintenanceAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public DirEntryMaintenanceGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/directory/{domain}/{entryUid}/mgmt";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domain}", URL.encodePathSegment(pathVars[0]));
				uri_ = uri_.replace("{entryUid}", URL.encodePathSegment(pathVars[1]));
		
		baseUri = uri_;
	}

	public DirEntryMaintenanceGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getAvailableOperations(final AsyncHandler<List<net.bluemind.directory.api.MaintenanceOperation>> handler) {
		String postUri = "/_maintenance";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.directory.api.MaintenanceOperation>>(handler) {
			@Override
			protected List<net.bluemind.directory.api.MaintenanceOperation> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.directory.api.gwt.serder.MaintenanceOperationGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void repair(net.bluemind.directory.api.RepairConfig config, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_maintenance/repair";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.directory.api.gwt.serder.RepairConfigGwtSerDer().serialize( config);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.directory.api.IDirEntryMaintenancePromise promiseApi() {
		return new DirEntryMaintenanceEndpointPromise(this);
	}
}
