/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.conditions.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterRuleFilterContainsModifier extends JavaScriptObject {

	protected JsMailFilterRuleFilterContainsModifier() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailFilterRuleFilterContainsModifier NONE()
	/*-{
		return "NONE";
	}-*/;

	public static final native JsMailFilterRuleFilterContainsModifier CASE_INSENSITIVE()
	/*-{
		return "CASE_INSENSITIVE";
	}-*/;

	public static final native JsMailFilterRuleFilterContainsModifier IGNORE_NONSPACING_MARK()
	/*-{
		return "IGNORE_NONSPACING_MARK";
	}-*/;

	public static final native JsMailFilterRuleFilterContainsModifier LOOSE()
	/*-{
		return "LOOSE";
	}-*/;

	public static final JsMailFilterRuleFilterContainsModifier create(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContains.Modifier value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NONE:
				return NONE();
			case CASE_INSENSITIVE:
				return CASE_INSENSITIVE();
			case IGNORE_NONSPACING_MARK:
				return IGNORE_NONSPACING_MARK();
			case LOOSE:
				return LOOSE();
			default:
				return null;
			}
		}
	}
}