/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.lib.ical4j.vcard;

import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.parameter.Altid;
import net.fortuna.ical4j.vcard.parameter.Calscale;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Fmttype;
import net.fortuna.ical4j.vcard.parameter.Geo;
import net.fortuna.ical4j.vcard.parameter.MediaType;
import net.fortuna.ical4j.vcard.parameter.Pid;
import net.fortuna.ical4j.vcard.parameter.Pref;
import net.fortuna.ical4j.vcard.parameter.SortAs;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Tz;
import net.fortuna.ical4j.vcard.parameter.Value;
import net.fortuna.ical4j.vcard.parameter.Version;

public class BmParameterFactoryRegistry extends ParameterFactoryRegistry {

	public BmParameterFactoryRegistry() {
		super();

		super.register(Parameter.Id.ALTID.getPname(), new Altid.Factory());
		super.register(Parameter.Id.CALSCALE.getPname(), new Calscale.Factory());
		super.register(Parameter.Id.MEDIATYPE.getPname(), new MediaType.Factory());
		super.register(Parameter.Id.ENCODING.getPname(), new Encoding.Factory());
		super.register(Parameter.Id.FMTTYPE.getPname(), new Fmttype.Factory());
		super.register(Parameter.Id.GEO.getPname(), new Geo.Factory());
		super.register(Parameter.Id.ALTID.getPname(), new Altid.Factory());
		super.register(Parameter.Id.PID.getPname(), new Pid.Factory());
		super.register(Parameter.Id.PREF.getPname(), new Pref.Factory());
		super.register(Parameter.Id.SORT_AS.getPname(), new SortAs.Factory());
		super.register(Parameter.Id.TYPE.getPname(), new Type.Factory());
		super.register(Parameter.Id.TZ.getPname(), new Tz.Factory());
		super.register(Parameter.Id.VALUE.getPname(), new Value.Factory());
		super.register(Parameter.Id.VERSION.getPname(), new Version.Factory());
	}

}
