package net.bluemind.webmodule.project.vite;

import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.webmodule.project.vite.internal.ViteDevResource;
import net.bluemind.webmodule.project.vite.internal.ViteProductionResource;
import net.bluemind.webmodule.server.project.Project;
import net.bluemind.webmodule.server.project.ProjectFactory;

public class ViteProjectFactory implements ProjectFactory {
	private static final Logger logger = LoggerFactory.getLogger(ViteProjectFactory.class);

	private static String TYPE = "vite";

	@Override
	public boolean canHandle(String type) {
		return TYPE.equalsIgnoreCase(type);
	}

	@Override
	public Project create(Bundle bundle) {
		BundleDevConfiguration conf = DevConfiguration.get().getBundleConfiguration(bundle);
		if (conf == null) {
			conf = intializeDevConfiguration(bundle);
		}
		logger.info("Initializing vite webmodule configuration for {} with dev-mode at {}", bundle.getSymbolicName(),
				conf.isEnabled());
		if (!DevConfiguration.get().isEnabled() || !conf.isEnabled()) {
			return new ViteProductionResource(bundle);
		} else {
			return new ViteDevResource(bundle, conf.getServer());
		}
	}

	private BundleDevConfiguration intializeDevConfiguration(Bundle bundle) {
		return DevConfiguration.get().register(bundle, new ViteDevResource(bundle).getServerDSN());
	}

}
