type MockClient<T> = {
    [K in keyof T]: T[K] extends (...args: any[]) => any ? ReturnType<typeof vi.fn> : never;
};

export const setupService = <S extends { client: any }, Args extends any[]>(
    ServiceClass: new (...args: Args) => S,
    ...args: Args
) => {
    const service = new ServiceClass(...args);
    const mockClient = service.client as unknown as MockClient<typeof service.client>;
    return { service, mockClient };
};
