import { SyncService } from "@bluemind/commons.light/model/synchronization";
import { ContainerChangeset, ContainerSubscriptionModel, OwnerSubscriptionsClient } from "@bluemind/core.container.api";
import ContainerDatasource, { type ContainerDB } from "@bluemind/service-worker-datasource";

export default class SubscriptionSyncService implements SyncService<ContainerSubscriptionModel, string> {
    client: OwnerSubscriptionsClient;
    db: Promise<ContainerDB<ContainerSubscriptionModel, string>>;
    constructor(uid: string, sid: string, domain: string) {
        const userId = uid.replace(".subscriptions", "").split("@")[0];
        this.client = new OwnerSubscriptionsClient(sid, domain, userId);
        this.db = ContainerDatasource.retrieve<ContainerSubscriptionModel, string>("subscription");
    }

    async getRemoteChangeSet(since: number) {
        const { created, updated, deleted, version } = (await this.client.changeset(since)) as Required<
            ContainerChangeset<string>
        >;

        const updatedIds = created.concat(updated);

        return { updated: updatedIds, deleted, version };
    }
    async getRemoteItems(uids: string[]) {
        return (await this.client.getMultiple(uids)).filter(Boolean);
    }

    async updateRemote() {
        //
    }

    async getLocalChangeSet(containerUid: string) {
        {
            const changeLog = await (await this.db).getChangeSet(containerUid);
            const { created, updated, deleted } = changeLog.reduce<{
                created: string[];
                updated: string[];
                deleted: string[];
            }>(
                (result, item) => {
                    const { action, uid } = item;
                    switch (action) {
                        case 0:
                            result.created?.push(uid);
                            break;
                        case 1:
                            result.updated?.push(uid);
                            break;
                        case 2:
                            result.deleted?.push(uid);
                            break;
                    }

                    return result;
                },
                { created: [], updated: [], deleted: [] }
            );
            return { created, updated, deleted, version: 0 };
        }
    }

    async resetData(containerUid: string): Promise<void> {
        await (await this.db).reset(containerUid);
    }
}
