/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.lib.vertx.utils;

import java.util.function.Function;
import java.util.function.IntSupplier;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;

public class ThrottleMessages<T> implements Handler<Message<T>> {
	private ThrottleAccumulator<T> throttler;

	public ThrottleMessages(Function<Message<T>, String> eventToKey, Handler<Message<T>> wrappedHandler, Vertx vertx,
			IntSupplier throttleTimeInMs) {
		this.throttler = new ThrottleAccumulator<>(vertx, throttleTimeInMs, eventToKey, wrappedHandler);
	}

	@Override
	public void handle(Message<T> event) {
		throttler.handle(event);
	}

}
