/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.adapter;

import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;

public class ExtendedFactory implements ParameterFactory<Parameter> {

	@SuppressWarnings("serial")
	@Override
	public Parameter createParameter(String name, String value) {
		Parameter p = new Parameter("EXTENDED") {

			@Override
			public String getValue() {
				return value;
			}
		};
		return p;
	}

	@Override
	public boolean supports(String id) {
		return id.equals("EXTENDED");
	}

}
