/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.size.helper;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;

import net.bluemind.core.caches.registry.CacheRegistry;
import net.bluemind.core.caches.registry.ICacheRegistration;
import net.bluemind.hornetq.client.MQ.SharedMap;
import net.bluemind.hornetq.client.Shared;

public class MaxMessageSize {

	private MaxMessageSize() {
	}

	private static final Cache<String, Integer> EXPIRING = Caffeine.newBuilder().expireAfterWrite(2, TimeUnit.MINUTES)
			.build();

	public static class Reg implements ICacheRegistration {

		@Override
		public void registerCaches(CacheRegistry cr) {
			cr.register("message_size_limit_cache", EXPIRING);
		}
	}

	public static final int get() {
		return EXPIRING.get("message_size_limit", k -> {
			SharedMap<String, String> sysconf = Shared.mapSysconf();
			String sizeAsInt = Optional.ofNullable(sysconf.get(k)).orElse("10000000");
			return Integer.valueOf(sizeAsInt);
		});
	}

}
