import { App } from "vue";

import i18n, { generateDateTimeFormats, TranslationRegistry } from "@bluemind/i18n";

import { inject } from "@bluemind/inject";

import BannerL10N from "../../l10n/banner/";
import SettingsL10N from "../../l10n/preferences/";
import RootAppL10N from "../../l10n/root/";

export const TranslationModule = {
    install: (
        app: App,
        options?: {
            userSession: {
                userId: string;
            };
        }
    ) => {
        const setDateTimeFormat = async (session: { userId: string }) => {
            if (session.userId) {
                const timeformat = await inject("UserSettingsPersistence").getOne(session.userId, "timeformat");
                const dateTimeFormats = generateDateTimeFormats(timeformat);
                Object.entries(dateTimeFormats).forEach(entry => {
                    i18n.global.setDateTimeFormat(entry[0], entry[1]);
                });
            }
        };
        setDateTimeFormat(options!.userSession);
        TranslationRegistry.register(BannerL10N);
        TranslationRegistry.register(RootAppL10N);
        TranslationRegistry.register(SettingsL10N);
        app.use(i18n);
    }
};
