/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.memory.pool.api;

import java.io.InputStream;

import io.netty.buffer.ByteBuf;

public interface IChunk {

	void release();

	boolean isReleased();

	/**
	 * @return a read only view on data
	 */
	ByteBuf openBuffer();

	/**
	 * @return a stream of data
	 */
	InputStream openStream();

	int getSize();

	/**
	 * @return a copy of this chunk data
	 */
	default byte[] read() {
		ByteBuf buf = openBuffer();
		byte[] tgt = new byte[buf.readableBytes()];
		buf.readBytes(tgt);
		return tgt;
	}

}