/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class SocketOptions {
    public static final long DEFAULT_CONNECT_TIMEOUT = 10L;
    public static final TimeUnit DEFAULT_CONNECT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_CONNECT_TIMEOUT_DURATION = Duration.ofSeconds(10L);
    public static final boolean DEFAULT_SO_KEEPALIVE = false;
    public static final boolean DEFAULT_TCP_USER_TIMEOUT_ENABLED = false;
    public static final boolean DEFAULT_SO_NO_DELAY = true;
    private final Duration connectTimeout;
    private final KeepAliveOptions keepAlive;
    private final TcpUserTimeoutOptions tcpUserTimeout;
    private final boolean extendedKeepAlive;
    private final boolean tcpNoDelay;

    protected SocketOptions(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.keepAlive = builder.keepAlive;
        this.extendedKeepAlive = builder.extendedKeepAlive;
        this.tcpNoDelay = builder.tcpNoDelay;
        this.tcpUserTimeout = builder.tcpUserTimeout;
    }

    protected SocketOptions(SocketOptions original) {
        this.connectTimeout = original.getConnectTimeout();
        this.keepAlive = original.getKeepAlive();
        this.extendedKeepAlive = original.isExtendedKeepAlive();
        this.tcpNoDelay = original.isTcpNoDelay();
        this.tcpUserTimeout = original.getTcpUserTimeout();
    }

    public static SocketOptions copyOf(SocketOptions options) {
        return new SocketOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().build();
    }

    public Builder mutate() {
        Builder builder = SocketOptions.builder();
        builder.connectTimeout = this.getConnectTimeout();
        builder.keepAlive = this.getKeepAlive();
        builder.tcpNoDelay = this.isTcpNoDelay();
        return builder;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive.isEnabled();
    }

    public KeepAliveOptions getKeepAlive() {
        return this.keepAlive;
    }

    boolean isExtendedKeepAlive() {
        return this.extendedKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean isEnableTcpUserTimeout() {
        return this.tcpUserTimeout.isEnabled();
    }

    public TcpUserTimeoutOptions getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    public static class TcpUserTimeoutOptions {
        public static final Duration DEFAULT_TCP_USER_TIMEOUT = Duration.ofSeconds(7875L);
        private final Duration tcpUserTimeout;
        private final boolean enabled;

        private TcpUserTimeoutOptions(Builder builder) {
            this.tcpUserTimeout = builder.tcpUserTimeout;
            this.enabled = builder.enabled;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder mutate() {
            Builder builder = TcpUserTimeoutOptions.builder();
            builder.enabled = this.isEnabled();
            builder.tcpUserTimeout = this.getTcpUserTimeout();
            return builder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Duration getTcpUserTimeout() {
            return this.tcpUserTimeout;
        }

        public static class Builder {
            private Duration tcpUserTimeout = DEFAULT_TCP_USER_TIMEOUT;
            private boolean enabled = false;

            private Builder() {
            }

            public Builder enable() {
                return this.enable(true);
            }

            public Builder disable() {
                return this.enable(false);
            }

            public Builder enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder tcpUserTimeout(Duration tcpUserTimeout) {
                LettuceAssert.notNull((Object)tcpUserTimeout, "Duration must not be null");
                LettuceAssert.isTrue(!tcpUserTimeout.isNegative(), "Duration must not be negative");
                this.tcpUserTimeout = tcpUserTimeout;
                return this;
            }

            public TcpUserTimeoutOptions build() {
                return new TcpUserTimeoutOptions(this);
            }
        }
    }

    public static class KeepAliveOptions {
        public static final int DEFAULT_COUNT = 9;
        public static final Duration DEFAULT_IDLE = Duration.ofHours(2L);
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(75L);
        private final int count;
        private final boolean enabled;
        private final Duration idle;
        private final Duration interval;

        private KeepAliveOptions(Builder builder) {
            this.count = builder.count;
            this.enabled = builder.enabled;
            this.idle = builder.idle;
            this.interval = builder.interval;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder mutate() {
            Builder builder = KeepAliveOptions.builder();
            builder.enabled = this.isEnabled();
            builder.count = this.getCount();
            builder.idle = this.getIdle();
            builder.interval = this.getInterval();
            return builder;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Duration getIdle() {
            return this.idle;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public static class Builder {
            private int count = 9;
            private boolean enabled = false;
            private Duration idle = DEFAULT_IDLE;
            private Duration interval = DEFAULT_INTERVAL;

            private Builder() {
            }

            public Builder count(int count) {
                LettuceAssert.isTrue(count >= 0, "Count must be greater 0");
                this.count = count;
                return this;
            }

            public Builder enable() {
                return this.enable(true);
            }

            public Builder disable() {
                return this.enable(false);
            }

            public Builder enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder idle(Duration idle) {
                LettuceAssert.notNull((Object)idle, "Idle time must not be null");
                LettuceAssert.isTrue(!idle.isNegative(), "Idle time must not be negative");
                this.idle = idle;
                return this;
            }

            public Builder interval(Duration interval) {
                LettuceAssert.notNull((Object)interval, "Interval time must not be null");
                LettuceAssert.isTrue(!interval.isNegative(), "Interval time must not be negative");
                this.interval = interval;
                return this;
            }

            public KeepAliveOptions build() {
                return new KeepAliveOptions(this);
            }
        }
    }

    public static class Builder {
        private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT_DURATION;
        private KeepAliveOptions keepAlive = KeepAliveOptions.builder().enable(false).build();
        private TcpUserTimeoutOptions tcpUserTimeout = TcpUserTimeoutOptions.builder().enable(false).build();
        private boolean tcpNoDelay = true;
        private boolean extendedKeepAlive = false;

        private Builder() {
        }

        public Builder connectTimeout(Duration connectTimeout) {
            LettuceAssert.notNull((Object)connectTimeout, "Connect timeout must not be null");
            LettuceAssert.isTrue(connectTimeout.toNanos() > 0L, "Connect timeout must be greater 0");
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Deprecated
        public Builder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
            LettuceAssert.isTrue(connectTimeout > 0L, "Connect timeout must be greater 0");
            LettuceAssert.notNull((Object)connectTimeoutUnit, "Connect timeout unit must not be null");
            return this.connectTimeout(Duration.ofNanos(connectTimeoutUnit.toNanos(connectTimeout)));
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = KeepAliveOptions.builder().enable(keepAlive).build();
            this.extendedKeepAlive = false;
            return this;
        }

        public Builder keepAlive(KeepAliveOptions keepAlive) {
            LettuceAssert.notNull((Object)keepAlive, "KeepAlive options must not be null");
            this.keepAlive = keepAlive;
            this.extendedKeepAlive = true;
            return this;
        }

        public Builder tcpUserTimeout(TcpUserTimeoutOptions tcpUserTimeout) {
            LettuceAssert.notNull((Object)tcpUserTimeout, "TcpUserTimeout options must not be null");
            this.tcpUserTimeout = tcpUserTimeout;
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public SocketOptions build() {
            return new SocketOptions(this);
        }
    }
}

