/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SpanId;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.protocol.SentryId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryTraceHeader {
    public static final String SENTRY_TRACE_HEADER = "sentry-trace";
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final Boolean sampled;
    private static final Pattern SENTRY_TRACEPARENT_HEADER_REGEX = Pattern.compile("^[ \\t]*(?<traceId>[0-9a-f]{32})-(?<spanId>[0-9a-f]{16})(?<sampled>-[01])?[ \\t]*$", 2);

    public SentryTraceHeader(@NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable Boolean sampled) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.sampled = sampled;
    }

    public SentryTraceHeader(@NotNull String value) throws InvalidSentryTraceHeaderException {
        Matcher matcher = SENTRY_TRACEPARENT_HEADER_REGEX.matcher(value);
        boolean matchesExist = matcher.matches();
        if (!matchesExist || matcher.group("traceId") == null || matcher.group("spanId") == null) {
            throw new InvalidSentryTraceHeaderException(value);
        }
        this.traceId = new SentryId(matcher.group("traceId"));
        this.spanId = new SpanId(matcher.group("spanId"));
        this.sampled = matcher.group("sampled") == null ? null : Boolean.valueOf("1".equals(matcher.group("sampled").substring(1)));
    }

    @NotNull
    public String getName() {
        return SENTRY_TRACE_HEADER;
    }

    @NotNull
    public String getValue() {
        if (this.sampled != null) {
            return String.format("%s-%s-%s", this.traceId, this.spanId, this.sampled != false ? "1" : "0");
        }
        return String.format("%s-%s", this.traceId, this.spanId);
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    public Boolean isSampled() {
        return this.sampled;
    }
}

