/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00b4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u00020\u0005*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0000\u001a)\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0000\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u001f\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u001aH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0012\u0010\u001d\u001a\u00020\u001e*\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u001a\u0012\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020\u001eH\u0000\u001a\u0014\u0010\"\u001a\u00020\u0007*\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u001a\f\u0010$\u001a\u00020%*\u00020&H\u0000\u001a\u001c\u0010'\u001a\u00020\u0007*\u00020(2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0019H\u0000\u001a\f\u0010'\u001a\u00020**\u00020\u0012H\u0000\u001a\u001c\u0010+\u001a\u00020\u0007*\u00020(2\u0006\u0010,\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0019H\u0000\u001a\f\u0010-\u001a\u00020\u0005*\u00020.H\u0000\u001a\u0014\u0010/\u001a\u00020\u0007*\u00020.2\u0006\u00100\u001a\u00020\u0012H\u0000\u001a\"\u00101\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u00020*03H\u0080\b\u00f8\u0001\u0000\u001a\f\u00104\u001a\u00020\u0017*\u000205H\u0000\u001a\u001f\u00106\u001a\b\u0012\u0004\u0012\u0002H70\u001f\"\u0004\b\u0000\u00107*\b\u0012\u0004\u0012\u0002H70\u001fH\u0080\b\u001a\u001f\u00106\u001a\b\u0012\u0004\u0012\u0002H708\"\u0004\b\u0000\u00107*\b\u0012\u0004\u0012\u0002H708H\u0080\b\u001a1\u00106\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u0002H;09\"\u0004\b\u0000\u0010:\"\u0004\b\u0001\u0010;*\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u0002H;09H\u0080\b\u001a\u001e\u0010<\u001a\b\u0012\u0004\u0012\u0002H70\u001f\"\u0004\b\u0000\u00107*\b\u0012\u0004\u0012\u0002H70\u001fH\u0000\u001a-\u0010=\u001a\b\u0012\u0004\u0012\u0002H70\u001f\"\u0004\b\u0000\u001072\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u0002H70\r\"\u0002H7H\u0001\u00a2\u0006\u0002\u0010?\u001a'\u0010<\u001a\b\u0012\u0004\u0012\u0002H70\u001f\"\u0004\b\u0000\u00107*\f\u0012\u0006\b\u0001\u0012\u0002H7\u0018\u00010\rH\u0000\u00a2\u0006\u0002\u0010?\u001a\f\u0010@\u001a\u00020**\u00020.H\u0000\u001a\f\u0010@\u001a\u00020**\u00020AH\u0000\u001a\f\u0010B\u001a\u00020\u0005*\u00020\u0017H\u0000\u001a\f\u0010B\u001a\u00020\u0005*\u00020\u0015H\u0000\u001a3\u0010C\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u001072\u0006\u0010D\u001a\u00020\u000e2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H70F2\u0006\u0010G\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010H\u001a\f\u0010J\u001a\u00020**\u00020KH\u0000\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010I\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010L\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"UTC", "Ljava/util/TimeZone;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "name", "", "daemon", "", "toHostHeader", "Lokhttp3/HttpUrl;", "includeDefaultPort", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "checkDuration", "", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Lkotlin/time/Duration;", "checkDuration-HG0u8IE", "(Ljava/lang/String;J)I", "toHeaders", "Lokhttp3/Headers;", "", "Lokhttp3/internal/http2/Header;", "toHeaderList", "canReuseConnectionFor", "other", "asFactory", "Lokhttp3/EventListener$Factory;", "Lokhttp3/EventListener;", "skipAll", "Lokio/Source;", "timeUnit", "", "discard", "timeout", "peerName", "Ljava/net/Socket;", "isHealthy", "source", "threadName", "block", "Lkotlin/Function0;", "headersContentLength", "Lokhttp3/Response;", "unmodifiable", "T", "", "", "K", "V", "toImmutableList", "immutableListOf", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "closeQuietly", "Ljava/net/ServerSocket;", "toHexString", "readFieldOrNull", "instance", "fieldType", "Ljava/lang/Class;", "fieldName", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "assertionsEnabled", "assertLockNotHeld", "Lokhttp3/Dispatcher;", "okHttpName", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-UtilJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n248#1:367\n248#1:368\n1#2:362\n1563#3:363\n1634#3,3:364\n*S KotlinDebug\n*F\n+ 1 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n266#1:367\n278#1:368\n132#1:363\n132#1:364,3\n*E\n"})
public final class _UtilJvmKt {
    @JvmField
    @NotNull
    public static final TimeZone UTC;
    @JvmField
    public static final boolean assertionsEnabled;
    @JvmField
    @NotNull
    public static final String okHttpName;

    @NotNull
    public static final ThreadFactory threadFactory(@NotNull String name, boolean daemon) {
        Intrinsics.checkNotNullParameter(name, "name");
        return arg_0 -> _UtilJvmKt.threadFactory$lambda$1(name, daemon, arg_0);
    }

    @NotNull
    public static final String toHostHeader(@NotNull HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        Intrinsics.checkNotNullParameter($this$toHostHeader, "<this>");
        String host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), ":", false, 2, null) ? '[' + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
        return includeDefaultPort || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme()) ? host + ':' + $this$toHostHeader.port() : host;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return _UtilJvmKt.toHostHeader(httpUrl, bl);
    }

    @NotNull
    public static final String format(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args, "args");
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(locale, format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) throws IOException {
        Charset charset2;
        Intrinsics.checkNotNullParameter($this$readBomAsCharset, "<this>");
        Intrinsics.checkNotNullParameter(charset, "default");
        switch ($this$readBomAsCharset.select(_UtilCommonKt.getUNICODE_BOMS())) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case 3: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return charset2;
    }

    public static final int checkDuration(@NotNull String name, long duration, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        if (!(duration >= 0L)) {
            boolean bl = false;
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        long millis = unit.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-_UtilJvmKt$checkDuration$42 = false;
            String $i$a$-require-_UtilJvmKt$checkDuration$42 = name + " too large";
            throw new IllegalArgumentException($i$a$-require-_UtilJvmKt$checkDuration$42.toString());
        }
        if (!(millis != 0L || duration <= 0L)) {
            boolean bl = false;
            String string = name + " too small";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    public static final int checkDuration-HG0u8IE(@NotNull String name, long duration) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(!Duration.isNegative-impl(duration))) {
            boolean bl = false;
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        long millis = Duration.getInWholeMilliseconds-impl(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-_UtilJvmKt$checkDuration$72 = false;
            String $i$a$-require-_UtilJvmKt$checkDuration$72 = name + " too large";
            throw new IllegalArgumentException($i$a$-require-_UtilJvmKt$checkDuration$72.toString());
        }
        if (!(millis != 0L || !Duration.isPositive-impl(duration))) {
            boolean bl = false;
            String string = name + " too small";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    @NotNull
    public static final Headers toHeaders(@NotNull List<Header> $this$toHeaders) {
        Intrinsics.checkNotNullParameter($this$toHeaders, "<this>");
        Headers.Builder builder = new Headers.Builder();
        for (Header header : $this$toHeaders) {
            ByteString name = header.component1();
            ByteString value = header.component2();
            builder.addLenient$okhttp(name.utf8(), value.utf8());
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Header> toHeaderList(@NotNull Headers $this$toHeaderList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderList, "<this>");
        Iterable $this$map$iv = RangesKt.until(0, $this$toHeaderList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Header($this$toHeaderList.name((int)it), $this$toHeaderList.value((int)it)));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean canReuseConnectionFor(@NotNull HttpUrl $this$canReuseConnectionFor, @NotNull HttpUrl other) {
        Intrinsics.checkNotNullParameter($this$canReuseConnectionFor, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual($this$canReuseConnectionFor.host(), other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual($this$canReuseConnectionFor.scheme(), other.scheme());
    }

    @NotNull
    public static final EventListener.Factory asFactory(@NotNull EventListener $this$asFactory) {
        Intrinsics.checkNotNullParameter($this$asFactory, "<this>");
        return arg_0 -> _UtilJvmKt.asFactory$lambda$9($this$asFactory, arg_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean skipAll(@NotNull Source $this$skipAll, int duration, @NotNull TimeUnit timeUnit) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$skipAll, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        long nowNs = System.nanoTime();
        long originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
        $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, timeUnit.toNanos(duration)));
        try {
            Buffer skipBuffer = new Buffer();
            while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            bl = true;
            Timeout timeout2 = originalDurationNs == Long.MAX_VALUE ? $this$skipAll.timeout().clearDeadline() : $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
        }
        catch (InterruptedIOException interruptedIOException) {
            try {
                bl = false;
                Timeout timeout3 = originalDurationNs == Long.MAX_VALUE ? $this$skipAll.timeout().clearDeadline() : $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
            }
            catch (Throwable throwable) {
                Timeout timeout4 = originalDurationNs == Long.MAX_VALUE ? $this$skipAll.timeout().clearDeadline() : $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
                throw throwable;
            }
        }
        return bl;
    }

    public static final void skipAll(@NotNull BufferedSource $this$skipAll) throws IOException {
        Intrinsics.checkNotNullParameter($this$skipAll, "<this>");
        while (!$this$skipAll.exhausted()) {
            $this$skipAll.skip($this$skipAll.getBuffer().size());
        }
    }

    public static final boolean discard(@NotNull Source $this$discard, int timeout2, @NotNull TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$discard, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            bl = _UtilJvmKt.skipAll($this$discard, timeout2, timeUnit);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String peerName(@NotNull Socket $this$peerName) {
        String string;
        Intrinsics.checkNotNullParameter($this$peerName, "<this>");
        SocketAddress address = $this$peerName.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            String string2 = ((InetSocketAddress)address).getHostName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getHostName(...)");
        } else {
            string = address.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isHealthy(@NotNull Socket $this$isHealthy, @NotNull BufferedSource source2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isHealthy, "<this>");
        Intrinsics.checkNotNullParameter(source2, "source");
        try {
            boolean bl2;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                $this$isHealthy.setSoTimeout(1);
                bl2 = !source2.exhausted();
            }
            finally {
                $this$isHealthy.setSoTimeout(readTimeout);
            }
            bl = bl2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void threadName(@NotNull String name, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$threadName = false;
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(name);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            currentThread.setName(oldName);
            InlineMarker.finallyEnd(1);
        }
    }

    public static final long headersContentLength(@NotNull Response $this$headersContentLength) {
        Intrinsics.checkNotNullParameter($this$headersContentLength, "<this>");
        String string = $this$headersContentLength.headers().get("Content-Length");
        return string != null ? _UtilCommonKt.toLongOrDefault(string, -1L) : -1L;
    }

    @NotNull
    public static final <T> List<T> unmodifiable(@NotNull List<? extends T> $this$unmodifiable) {
        Intrinsics.checkNotNullParameter($this$unmodifiable, "<this>");
        boolean $i$f$unmodifiable = false;
        List<? extends T> list = Collections.unmodifiableList($this$unmodifiable);
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(...)");
        return list;
    }

    @NotNull
    public static final <T> Set<T> unmodifiable(@NotNull Set<? extends T> $this$unmodifiable) {
        Intrinsics.checkNotNullParameter($this$unmodifiable, "<this>");
        boolean $i$f$unmodifiable = false;
        Set<? extends T> set = Collections.unmodifiableSet($this$unmodifiable);
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    @NotNull
    public static final <K, V> Map<K, V> unmodifiable(@NotNull Map<K, ? extends V> $this$unmodifiable) {
        Intrinsics.checkNotNullParameter($this$unmodifiable, "<this>");
        boolean $i$f$unmodifiable = false;
        Map<K, ? extends V> map = Collections.unmodifiableMap($this$unmodifiable);
        Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@NotNull List<? extends T> $this$toImmutableList) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$toImmutableList, "<this>");
        if ($this$toImmutableList.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if ($this$toImmutableList.size() == 1) {
            List<T> list2 = Collections.singletonList($this$toImmutableList.get(0));
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, "singletonList(...)");
        } else {
            Object[] objectArray = ((Collection)$this$toImmutableList).toArray();
            Intrinsics.checkNotNullExpressionValue(objectArray, "toArray(...)");
            List<Object> $this$unmodifiable$iv = ArraysKt.asList(objectArray);
            boolean $i$f$unmodifiable = false;
            List<Object> list3 = Collections.unmodifiableList($this$unmodifiable$iv);
            Intrinsics.checkNotNullExpressionValue(list3, "unmodifiableList(...)");
            list = list3;
            Intrinsics.checkNotNull(list3, "null cannot be cast to non-null type kotlin.collections.List<T of okhttp3.internal._UtilJvmKt.toImmutableList>");
        }
        return list;
    }

    @SafeVarargs
    @NotNull
    public static final <T> List<T> immutableListOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return _UtilJvmKt.toImmutableList(elements);
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@Nullable T[] $this$toImmutableList) {
        List<Object> list;
        T[] TArray = $this$toImmutableList;
        if (TArray == null || TArray.length == 0) {
            list = CollectionsKt.emptyList();
        } else if ($this$toImmutableList.length == 1) {
            List<T> list2 = Collections.singletonList($this$toImmutableList[0]);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, "singletonList(...)");
        } else {
            List<Object> $this$unmodifiable$iv = ArraysKt.asList((Object[])$this$toImmutableList.clone());
            boolean $i$f$unmodifiable = false;
            List<Object> list3 = Collections.unmodifiableList($this$unmodifiable$iv);
            list = list3;
            Intrinsics.checkNotNullExpressionValue(list3, "unmodifiableList(...)");
        }
        return list;
    }

    public static final void closeQuietly(@NotNull Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (RuntimeException rethrown) {
            if (Intrinsics.areEqual(rethrown.getMessage(), "bio == null")) {
                return;
            }
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeQuietly(@NotNull ServerSocket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(...)");
        return string;
    }

    @NotNull
    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(...)");
        return string;
    }

    @Nullable
    public static final <T> T readFieldOrNull(@NotNull Object instance, @NotNull Class<T> fieldType, @NotNull String fieldName) {
        Object delegate;
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(fieldType, "fieldType");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Class<?> c = instance.getClass();
        while (!Intrinsics.areEqual(c, Object.class)) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(instance);
                return !fieldType.isInstance(value) ? null : (T)fieldType.cast(value);
            }
            catch (NoSuchFieldException field) {
                Intrinsics.checkNotNullExpressionValue(c.getSuperclass(), "getSuperclass(...)");
            }
        }
        if (!Intrinsics.areEqual(fieldName, "delegate") && (delegate = _UtilJvmKt.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return _UtilJvmKt.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    public static final void assertLockNotHeld(@NotNull Dispatcher $this$assertLockNotHeld) {
        Intrinsics.checkNotNullParameter($this$assertLockNotHeld, "<this>");
        if (assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld));
        }
    }

    private static final Thread threadFactory$lambda$1(String $name, boolean $daemon, Runnable runnable2) {
        Thread thread2;
        Thread $this$threadFactory_u24lambda_u241_u24lambda_u240 = thread2 = new Thread(runnable2, $name);
        boolean bl = false;
        $this$threadFactory_u24lambda_u241_u24lambda_u240.setDaemon($daemon);
        return thread2;
    }

    private static final EventListener asFactory$lambda$9(EventListener $this_asFactory, Call it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $this_asFactory;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull(timeZone);
        UTC = timeZone;
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        okHttpName = StringsKt.removeSuffix(StringsKt.removePrefix(string, (CharSequence)"okhttp3."), (CharSequence)"Client");
    }
}

