package net.bluemind.webmodule.project.vite;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.utils.JsonUtils;

public class DevConfiguration {
	private static final Logger logger = LoggerFactory.getLogger(DevConfiguration.class);
	private static final Path configurationFile = Paths.get("/etc/bm-webserver/dev.json");
	public static final boolean DEV_MODE = Files.exists(Paths.get("/root/dev-vue"));
	private static final DevConfiguration instance;

	static {
		instance = load();
	}

	private static DevConfiguration load() {
		if (Files.exists(configurationFile)) {
			try {
				String content = Files.readString(configurationFile);
				return JsonUtils.read(content, DevConfiguration.class);
			} catch (IOException e) {
				logger.error("Could not read {}", configurationFile, e);
				return new DevConfiguration();
			}
		}
		return new DevConfiguration();
	}

	public static DevConfiguration get() {
		return instance;
	}

	private DevConfiguration() {
	}

	public Map<String, BundleDevConfiguration> bundles = new HashMap<>();
	private boolean enabled;

	public boolean isEnabled() {
		return DEV_MODE && enabled;
	}

	public void enable() {
		enabled = true;
	}

	public void disable() {
		enabled = false;
	}

	public BundleDevConfiguration getBundleConfiguration(Bundle bundle) {
		return bundles.get(bundle.getSymbolicName());
	}

	public BundleDevConfiguration register(Bundle bundle, URI defaultServer) {
		if (!bundles.containsKey(bundle.getSymbolicName())) {
			bundles.put(bundle.getSymbolicName(), BundleDevConfiguration.defaultConfiguration(defaultServer));
		}
		return bundles.get(bundle.getSymbolicName());
	}

	public void save() {
		byte[] content = JsonUtils.asBytes(this);
		try {
			Files.write(configurationFile, content);
		} catch (IOException e) {
			logger.error("Could not save {}", configurationFile, e);
		}
	}

	public void merge(DevConfiguration conf) {
		enabled = conf.enabled;
		if (conf.bundles != null) {
			conf.bundles.keySet().forEach(bundle -> {
				if (bundles.containsKey(bundle)) {
					bundles.get(bundle).merge(conf.bundles.get(bundle));
				}
			});
		}
	}

}
