package net.bluemind.backend.mail.replica.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.backend.mail.replica.api.IDbReplicatedMailboxesAsync.class)
public interface IDbReplicatedMailboxesPromise  {

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> all();

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.replica.api.MailboxReplica>>> allReplicas();

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> byName(java.lang.String name);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.replica.api.MailboxReplica>> byReplicaName(java.lang.String name);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> childrensOf(java.lang.String folderUid);

	CompletableFuture<net.bluemind.core.container.api.Ack> create(java.lang.String uid, net.bluemind.backend.mail.replica.api.MailboxReplica replica);

	CompletableFuture<Void> delete(java.lang.String uid);

	CompletableFuture<Void> deleteNoTrash(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.replica.api.MailboxReplica>> getCompleteById(long id);

	CompletableFuture<java.lang.String> getFullName(java.lang.String uid);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.replica.api.MailboxReplica>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.backend.mail.replica.api.AppendTx> prepareAppend(long replicaId, java.lang.Integer count);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> root();

	CompletableFuture<net.bluemind.backend.mail.api.SearchResult> searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery arg0);

	CompletableFuture<net.bluemind.core.container.model.ItemVersion> touch(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> trash();

	CompletableFuture<net.bluemind.core.container.api.Ack> update(java.lang.String uid, net.bluemind.backend.mail.replica.api.MailboxReplica replica);

}