/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.api;

import java.util.List;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class PermittedVerbs {
	public List<String> verbs;
	public boolean can;

	public PermittedVerbs() {
	}

	public static PermittedVerbs create(List<String> verbs) {
		PermittedVerbs permittedVerbs = new PermittedVerbs();
		permittedVerbs.verbs = verbs;
		permittedVerbs.can = verbs != null && !verbs.isEmpty();
		return permittedVerbs;
	}

	public List<String> getVerbs() {
		return this.verbs;
	}

	public boolean can() {
		return can;
	}

	public boolean can(String verb) {
		return verbs.contains(verb);
	}
}
