import { App } from "vue";

import serviceWorker from "@bluemind/commons/utils/service-worker";
import session, { type SessionInfos } from "@bluemind/session";

export const SessionModule = {
    install: (app: App, { userSession }: { userSession: SessionInfos }) => {
        session.set(userSession);

        serviceWorker.addMessageListener("REFRESH_SESSION", ({ sid }) => {
            if (sid && session.sid !== sid) {
                location.reload();
            }
        });
    }
};
