import { watch } from "vue";

import { useBluetifulConfig } from "@bluemind/bluetiful";
import store from "@bluemind/store";

export function useBluetifulSettingsSync() {
    const config = useBluetifulConfig();

    const applyThemeToBody = (newTheme: string | undefined, oldTheme?: string) => {
        if (oldTheme) {
            document.body.classList.remove(oldTheme);
        }
        if (newTheme !== undefined) {
            document.body.classList.add(newTheme);
        }
    };

    const syncWithBluetifulConfig = (updates: { darkMode?: boolean; defaultFontSize?: string }) => {
        if (config) {
            const syncConf = (name: "darkMode" | "defaultFontSize") => {
                if (config[name] && updates && Object.keys(updates).includes(name)) {
                    config[name].value = updates[name];
                }
            };
            syncConf("darkMode");
            syncConf("defaultFontSize");
        }
    };

    watch(
        () => store.state.settings.theme,
        (newValue: string | undefined, oldValue?: string) => {
            applyThemeToBody(newValue, oldValue);
            syncWithBluetifulConfig({
                darkMode: newValue === "dark" ? true : newValue === "light" ? false : undefined
            });
        },
        { immediate: true }
    );

    watch(
        () => store.state.settings.composer_default_font_size,
        (newValue: string) => {
            if (newValue) {
                syncWithBluetifulConfig({ defaultFontSize: newValue });
            }
        },
        { immediate: true }
    );

    return {
        syncWithBluetifulConfig
    };
}
