import { mapExtensions } from "@bluemind/extensions";
import i18n from "@bluemind/i18n";

import account from "./account";
import { merge, reactive, sanitize } from "./builder";
import calendar from "./calendar";
import contacts from "./contacts";
import downloads from "./downloads";
import mail from "./mail";
import todolists from "./todolists";

export default function (vm) {
    let preferences = defaultSections(vm);
    preferences = merge(preferences, extendedPreferences());
    preferences = sanitize(preferences);
    return reactive(preferences, vm);
}

function defaultSections() {
    let preferences = merge([], account(i18n.global));
    preferences = merge(preferences, calendar(i18n.global));
    preferences = merge(preferences, downloads(i18n.global));
    preferences = merge(preferences, mail(i18n.global));
    preferences = merge(preferences, contacts(i18n.global));
    return merge(preferences, todolists(i18n.global));
}

function extendedPreferences() {
    const sections = mapExtensions("webapp.preferences", ["section"]).section;
    return (sections || []).reduce((preferences, section) => {
        const extendedSection = section.raw ? JSON.parse(section.raw) : section;
        return merge(preferences, extendedSection);
    }, []);
}
