import qrcode from "qrcode";
import { base32 } from "rfc4648";

export function useSecret() {
    const CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"; // same characters used by Keycloak

    async function generateSecret(
        name: string
    ): Promise<{ secret: string; secret32: string; qrCode: string; uri: string }> {
        const bytes = crypto
            .getRandomValues(new Uint8Array(20))
            .map((b: number) => CHARS.charCodeAt(Math.floor((b * CHARS.length) / 256)));
        const secret32 = base32.stringify(bytes);
        const secret = new TextDecoder().decode(bytes);
        const uri = `otpauth://totp/${name}?secret=${secret32}&digits=6&algorithm=SHA1&period=30&issuer=BlueMind`;
        const qrCode = await qrcode.toDataURL(uri, { width: 128 + 2 * 12 /*margin*/ });
        return { secret, secret32, qrCode, uri };
    }

    return { generateSecret };
}
