import serviceWorker from "@bluemind/commons/utils/service-worker";
import session from "@bluemind/session";
import WebSocketClient from "@bluemind/sockjs";

const ClientState = {
    CONNECTED: "CONNECTED",
    DISCONNECTED: "DISCONNECTED",
    PENDING: "PENDING"
} as const;

type State = (typeof ClientState)[keyof typeof ClientState];
export const ClientStateObserver = {
    start() {
        this.setState(ClientState.PENDING);
        const socket = new WebSocketClient();
        socket.onOnlineChange((event: any) => {
            this.setState(event?.online ? ClientState.CONNECTED : ClientState.DISCONNECTED);
        });
        if (socket.isOnline()) {
            this.setState(ClientState.CONNECTED);
        }
    },
    setState(state: State) {
        serviceWorker.postMessage(state, null, { sid: session.sid });
    }
};
