<#macro header recipients subject date msg>

        <h2>
        <#if recipients?size == 1>
            ${msg("ndr.global.title.single", recipients?first)}
        <#elseif recipients?size == 0>
            ${msg("ndr.global.title.norecipient")}
        <#else>
            ${msg("ndr.global.title.multiple", recipients?size)}
        </#if>
        </h2>


        <table class="mail-info" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <table class="row" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                <span class="key">${msg("ndr.global.subject")}</span>
                                <span class="value">${subject}</span>
                            </td>
                        </tr>
                    </table>
                    <table class="row" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                <span class="key">${msg("ndr.global.send_date")}</span>
                                <span class="value">${date}</span>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
</#macro>
<#macro block infos msg>
        <table class="table" cellpadding="0" cellspacing="0">
            <tr>
                <td class="cell">
                    <h3><@codemsg msg=msg key="title" code=infos.i18n /></h3>
                    <table class="addresses" cellpadding="0" cellspacing="0">
                    <#list infos.emails as email>
                        <tr>
                            <td class="address">${email}</td>
                        </tr>
                    </#list>
                    </table>
                    <table class="error-info" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                <span class="code">${msg("ndr.global.error.code", infos.fullCode)}</span>
                                <span class="state"><@codemsg msg=msg key="culprit" code=infos.i18n /></span>
                            </td>
                        </tr>
                    </table>
                    <table class="help" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                <@codemsg msg=msg key="action" code=infos.i18n params=[infos.from] />
                                <table cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td>
                                            <a href="https://doc.bluemind.net/" target="_blank">${msg("ndr.global.more_infos")}</a>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                    <table class="technical" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                ${msg("ndr.global.details")}<br />
                                Error: ${infos.fullCode} Remote server returned an error -> ${infos.code} ${infos.errorMsg}<br />
                                Message rejected by: ${infos.transportAgent}
                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
</#macro>
<#macro codemsg msg key code params = []>
    <#if msg("ndr." + code + "." + key) == "">
        ${msg("ndr.fallback." + key)}
    <#elseif params?size == 0>
            ${msg("ndr." + code + "." + key)}
    <#else>
        ${msg("ndr." + code + "." + key, params?join(", "))}
    </#if>
</#macro>