/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.identity.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class IdentityDescriptionGwtSerDer implements GwtSerDer<net.bluemind.mailbox.identity.api.IdentityDescription> {

	public IdentityDescriptionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.identity.api.IdentityDescription deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.identity.api.IdentityDescription ret = new net.bluemind.mailbox.identity.api.IdentityDescription();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.identity.api.IdentityDescription ret, JSONObject json) {
		JSONValue mboxJSON = json.get("mbox");
		ret.mbox =  GwtSerDerUtils.STRING.deserialize(mboxJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue emailIsDefaultJSON = json.get("emailIsDefault");
		ret.emailIsDefault =  GwtSerDerUtils.BOOLEAN.deserialize(emailIsDefaultJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue isDefaultJSON = json.get("isDefault");
		ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		JSONValue displaynameJSON = json.get("displayname");
		ret.displayname =  GwtSerDerUtils.STRING.deserialize(displaynameJSON);
		JSONValue signatureJSON = json.get("signature");
		ret.signature =  GwtSerDerUtils.STRING.deserialize(signatureJSON);
		JSONValue mboxNameJSON = json.get("mboxName");
		ret.mboxName =  GwtSerDerUtils.STRING.deserialize(mboxNameJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.identity.api.IdentityDescription ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("mbox")) {
			JSONValue mboxJSON = json.get("mbox");
			ret.mbox =  GwtSerDerUtils.STRING.deserialize(mboxJSON);
		}
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("email")) {
			JSONValue emailJSON = json.get("email");
			ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		}
		if (!childPropertiesToIgnore.contains("emailIsDefault")) {
			JSONValue emailIsDefaultJSON = json.get("emailIsDefault");
			ret.emailIsDefault =  GwtSerDerUtils.BOOLEAN.deserialize(emailIsDefaultJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			JSONValue isDefaultJSON = json.get("isDefault");
			ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		}
		if (!childPropertiesToIgnore.contains("displayname")) {
			JSONValue displaynameJSON = json.get("displayname");
			ret.displayname =  GwtSerDerUtils.STRING.deserialize(displaynameJSON);
		}
		if (!childPropertiesToIgnore.contains("signature")) {
			JSONValue signatureJSON = json.get("signature");
			ret.signature =  GwtSerDerUtils.STRING.deserialize(signatureJSON);
		}
		if (!childPropertiesToIgnore.contains("mboxName")) {
			JSONValue mboxNameJSON = json.get("mboxName");
			ret.mboxName =  GwtSerDerUtils.STRING.deserialize(mboxNameJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.identity.api.IdentityDescription o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.identity.api.IdentityDescription o, JSONObject ret) {

		ret.put("mbox",  GwtSerDerUtils.STRING.serialize( o.mbox ));
		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("emailIsDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.emailIsDefault ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		ret.put("displayname",  GwtSerDerUtils.STRING.serialize( o.displayname ));
		ret.put("signature",  GwtSerDerUtils.STRING.serialize( o.signature ));
		ret.put("mboxName",  GwtSerDerUtils.STRING.serialize( o.mboxName ));
	}

	public void serializeTo(net.bluemind.mailbox.identity.api.IdentityDescription o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("mbox")) {
			ret.put("mbox",  GwtSerDerUtils.STRING.serialize( o.mbox ));
		}
		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("email")) {
			ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		}
		if (!childPropertiesToIgnore.contains("emailIsDefault")) {
			ret.put("emailIsDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.emailIsDefault ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		}
		if (!childPropertiesToIgnore.contains("displayname")) {
			ret.put("displayname",  GwtSerDerUtils.STRING.serialize( o.displayname ));
		}
		if (!childPropertiesToIgnore.contains("signature")) {
			ret.put("signature",  GwtSerDerUtils.STRING.serialize( o.signature ));
		}
		if (!childPropertiesToIgnore.contains("mboxName")) {
			ret.put("mboxName",  GwtSerDerUtils.STRING.serialize( o.mboxName ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}