/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementVAlarmAction extends JavaScriptObject {

	protected JsICalendarElementVAlarmAction() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementVAlarmAction Audio()
	/*-{
		return "Audio";
	}-*/;

	public static final native JsICalendarElementVAlarmAction Display()
	/*-{
		return "Display";
	}-*/;

	public static final native JsICalendarElementVAlarmAction Email()
	/*-{
		return "Email";
	}-*/;

	public static final JsICalendarElementVAlarmAction create(net.bluemind.icalendar.api.ICalendarElement.VAlarm.Action value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Audio:
				return Audio();
			case Display:
				return Display();
			case Email:
				return Email();
			default:
				return null;
			}
		}
	}
}