/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElement extends JavaScriptObject {

	protected JsICalendarElement() {}

	public final native net.bluemind.core.api.date.gwt.js.JsBmDateTime getDtstart()
	/*-{
	return this["dtstart"];
	}-*/;

	public final native void setDtstart(net.bluemind.core.api.date.gwt.js.JsBmDateTime dtstart)
	/*-{
       this["dtstart"] = dtstart;
	}-*/;

	public final native String getSummary()
	/*-{
	return this["summary"];
	}-*/;

	public final native void setSummary(String summary)
	/*-{
       this["summary"] = summary;
	}-*/;

	public final native net.bluemind.icalendar.api.gwt.js.JsICalendarElementClassification getClassification()
	/*-{
	return this["classification"];
	}-*/;

	public final native void setClassification(net.bluemind.icalendar.api.gwt.js.JsICalendarElementClassification classification)
	/*-{
       this["classification"] = classification;
	}-*/;

	public final native String getLocation()
	/*-{
	return this["location"];
	}-*/;

	public final native void setLocation(String location)
	/*-{
       this["location"] = location;
	}-*/;

	public final native String getDescription()
	/*-{
	return this["description"];
	}-*/;

	public final native void setDescription(String description)
	/*-{
       this["description"] = description;
	}-*/;

	public final native Integer getPriority()
	/*-{
	return ( this["priority"] != null) ? @java.lang.Integer::new(I)(this["priority"]) : null;
	}-*/;

	public final native void setPriority(Integer priority)
	/*-{
       this["priority"] =  ( priority != null) ? priority.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementVAlarm> getAlarm()
	/*-{
	return this["alarm"];
	}-*/;

	public final native void setAlarm(com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementVAlarm> alarm)
	/*-{
       this["alarm"] = alarm;
	}-*/;

	public final native net.bluemind.icalendar.api.gwt.js.JsICalendarElementStatus getStatus()
	/*-{
	return this["status"];
	}-*/;

	public final native void setStatus(net.bluemind.icalendar.api.gwt.js.JsICalendarElementStatus status)
	/*-{
       this["status"] = status;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementAttendee> getAttendees()
	/*-{
	return this["attendees"];
	}-*/;

	public final native void setAttendees(com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementAttendee> attendees)
	/*-{
       this["attendees"] = attendees;
	}-*/;

	public final native net.bluemind.icalendar.api.gwt.js.JsICalendarElementOrganizer getOrganizer()
	/*-{
	return this["organizer"];
	}-*/;

	public final native void setOrganizer(net.bluemind.icalendar.api.gwt.js.JsICalendarElementOrganizer organizer)
	/*-{
       this["organizer"] = organizer;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.tag.api.gwt.js.JsTagRef> getCategories()
	/*-{
	return this["categories"];
	}-*/;

	public final native void setCategories(com.google.gwt.core.client.JsArray<net.bluemind.tag.api.gwt.js.JsTagRef> categories)
	/*-{
       this["categories"] = categories;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.core.api.date.gwt.js.JsBmDateTime> getExdate()
	/*-{
	return this["exdate"];
	}-*/;

	public final native void setExdate(com.google.gwt.core.client.JsArray<net.bluemind.core.api.date.gwt.js.JsBmDateTime> exdate)
	/*-{
       this["exdate"] = exdate;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.core.api.date.gwt.js.JsBmDateTime> getRdate()
	/*-{
	return this["rdate"];
	}-*/;

	public final native void setRdate(com.google.gwt.core.client.JsArray<net.bluemind.core.api.date.gwt.js.JsBmDateTime> rdate)
	/*-{
       this["rdate"] = rdate;
	}-*/;

	public final native net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRule getRrule()
	/*-{
	return this["rrule"];
	}-*/;

	public final native void setRrule(net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRule rrule)
	/*-{
       this["rrule"] = rrule;
	}-*/;

	public final native String getUrl()
	/*-{
	return this["url"];
	}-*/;

	public final native void setUrl(String url)
	/*-{
       this["url"] = url;
	}-*/;

	public final native String getConference()
	/*-{
	return this["conference"];
	}-*/;

	public final native void setConference(String conference)
	/*-{
       this["conference"] = conference;
	}-*/;

	public final native String getConferenceId()
	/*-{
	return this["conferenceId"];
	}-*/;

	public final native void setConferenceId(String conferenceId)
	/*-{
       this["conferenceId"] = conferenceId;
	}-*/;

	public final native net.bluemind.core.commons.gwt.JsMapStringString getConferenceConfiguration()
	/*-{
	return this["conferenceConfiguration"];
	}-*/;

	public final native void setConferenceConfiguration(net.bluemind.core.commons.gwt.JsMapStringString conferenceConfiguration)
	/*-{
       this["conferenceConfiguration"] = conferenceConfiguration;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.attachment.api.gwt.js.JsAttachedFile> getAttachments()
	/*-{
	return this["attachments"];
	}-*/;

	public final native void setAttachments(com.google.gwt.core.client.JsArray<net.bluemind.attachment.api.gwt.js.JsAttachedFile> attachments)
	/*-{
       this["attachments"] = attachments;
	}-*/;

	public final native net.bluemind.core.commons.gwt.JsMapStringString getProperties()
	/*-{
	return this["properties"];
	}-*/;

	public final native void setProperties(net.bluemind.core.commons.gwt.JsMapStringString properties)
	/*-{
       this["properties"] = properties;
	}-*/;

	public final native Integer getSequence()
	/*-{
	return ( this["sequence"] != null) ? @java.lang.Integer::new(I)(this["sequence"]) : null;
	}-*/;

	public final native void setSequence(Integer sequence)
	/*-{
       this["sequence"] =  ( sequence != null) ? sequence.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native boolean getDraft()
	/*-{
	return this["draft"];
	}-*/;

	public final native void setDraft(boolean draft)
	/*-{
       this["draft"] = draft;
	}-*/;

	public static native  JsICalendarElement create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}