/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MaintenanceOperationGwtSerDer implements GwtSerDer<net.bluemind.directory.api.MaintenanceOperation> {

	public MaintenanceOperationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.MaintenanceOperation deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.MaintenanceOperation ret = new net.bluemind.directory.api.MaintenanceOperation();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.MaintenanceOperation ret, JSONObject json) {
		JSONValue identifierJSON = json.get("identifier");
		ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
	}

	public void deserializeTo(net.bluemind.directory.api.MaintenanceOperation ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("identifier")) {
			JSONValue identifierJSON = json.get("identifier");
			ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.directory.api.MaintenanceOperation o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.MaintenanceOperation o, JSONObject ret) {

		ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
	}

	public void serializeTo(net.bluemind.directory.api.MaintenanceOperation o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("identifier")) {
			ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}