/* eslint-disable @typescript-eslint/no-non-null-assertion */
import pRetry from "p-retry";

import type { FolderCounters, MailboxFolder, MailboxItem } from "@bluemind/backend.mail.api";
import { MailboxFoldersClient } from "@bluemind/backend.mail.api";
import { ItemFlag, type ItemValue } from "@bluemind/core.container.api";
import logger from "@bluemind/logger";
import ContainerDatasource from "@bluemind/service-worker-datasource";

import { isLocal, isSynchronized, nudgeSync } from "../../Synchronization/SyncUtils";

import type { MailboxRecordsDB } from "./MailboxRecordsDB";
class NoContentError extends Error {
    constructor(message = "") {
        super(message);
        this.name = "NoContentError";
    }
}
export default class extends MailboxFoldersClient {
    next?: (...args: Array<unknown>) => Promise<never>;
    containerUid: string;
    constructor(apiKey: string, partition: string, mailboxRoot: string, base?: string) {
        super(apiKey, partition, mailboxRoot, base);
        this.containerUid = `mailbox:acls-${mailboxRoot?.replace(/^user\./, "")}`;
    }

    //FIXME : ITINERIS
    /* async updateById(id: number, value?: MailboxFolder) {
        try {
            if (value) {
                const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
                db.putItemsAndCommit([{ value: value, internalId: id }], this.containerUid);
                relaxedSynchronize(this.containerUid, "mailboxacl");

                return {
                    version: (await db.getSyncStatus(this.containerUid))?.version || 0,
                    timestamp: new Date().getTime()
                };
            }
        } catch (error) {
            logger.error(`[MailboxFolderLocalDBProxy] Failed to update folder id ${id}, ignore PROXY`, error);
        }
        return this.next!();
    } */

    async getCompleteById(id: number) {
        try {
            if (!(await isLocal(this.containerUid, "mailboxacl"))) {
                return this.next!();
            }

            if (!isSynchronized(this.containerUid, "mailboxacl")) {
                await nudgeSync(this.containerUid, "mailboxacl");
            }

            const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
            return (await db.getItems([id], this.containerUid))[0];
        } catch (error) {
            logger.error(`[MailboxFolderLocalDBProxy] Failed to getCompleteById folder id ${id}, ignore PROXY`, error);
        }
        return this.next!();
    }
    async all() {
        try {
            if (!(await isLocal(this.containerUid, "mailboxacl"))) {
                return this.next!();
            }

            if (!isSynchronized(this.containerUid, "mailboxacl")) {
                await nudgeSync(this.containerUid, "mailboxacl");
            }

            const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
            return await db.getAllItems(this.containerUid);
        } catch (error) {
            logger.error(`[MailboxFolderLocalDBProxy] Failed to get all folders, ignore PROXY`, error);
        }
        return this.next!();
    }

    async byName(name: string): Promise<ItemValue<MailboxFolder>> {
        try {
            if (!(await isLocal(this.containerUid, "mailboxacl"))) {
                return this.next!();
            }

            if (!isSynchronized(this.containerUid, "mailboxacl")) {
                await nudgeSync(this.containerUid, "mailboxacl");
            }
            const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
            const folders = await db.getAllItems(this.containerUid.replace("user.", ""));
            const folderByName = folders.find(folder => folder.value.name === name);

            if (folderByName) {
                return folderByName;
            } else {
                throw new NoContentError();
            }
        } catch (error) {
            logger.error(
                `[MailboxFolderLocalDBProxy] Failed to get folder byName with name ${name}, ignore PROXY`,
                error
            );
        }
        return this.next!();
    }
    async counters(folderItemIds?: number[]): Promise<FolderCounters[]> {
        try {
            if (!(await isLocal(this.containerUid, "mailboxacl"))) {
                return this.next!();
            }

            if (!isSynchronized(this.containerUid, "mailboxacl")) {
                await nudgeSync(this.containerUid, "mailboxacl");
            }
            const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
            const dbRecords = (await ContainerDatasource.retrieve<MailboxItem, number>(
                "mail_record"
            )) as MailboxRecordsDB;
            const folders = await db.getItems(folderItemIds || [], this.containerUid);
            const foldersUids = folders.map(folder => folder.uid) as string[];

            const lightItemsByFolder = await dbRecords.getAllItemLightByFolders(foldersUids);

            const uidToInternalId = new Map(folders.map(folder => [folder.uid, folder.internalId]));

            return [...lightItemsByFolder].map(([uid, lightItems]) => ({
                itemId: uidToInternalId.get(uid)!,
                unseenVisible: lightItems.filter(item => !item.flags?.includes(ItemFlag.Seen)).length,
                totalVisible: lightItems.length,
                total: lightItems.length
            }));
        } catch (error) {
            logger.error(
                `[MailboxFolderLocalDBProxy] Failed to get counters for ids ${folderItemIds}, ignore PROXY`,
                error
            );
        }
        return this.next!();
    }
    //FIXME : ITINERIS
    /* async removeMessages(id: number): Promise<void> {
        try {
            const db = await ContainerDatasource.retrieve<MailboxFolder, number>("mailboxacl");
            const folder = (await db.getItems([Number(id)], this.containerUid))[0];
            const dbMail = await ContainerDatasource.retrieve<MailboxItem, number>("mail_record");
            const mails = await dbMail.getAllItems(folder.uid!);
            const internalIds = mails.map(item => item.internalId) as number[];
            await dbMail.deleteItems(internalIds as [], folder.uid!);
            relaxedSynchronize(folder.uid!, "mail_record");
            return;
        } catch (error) {
            logger.error(`[MailboxFolderLocalDBProxy] Failed to removeMessages with id ${id}, ignore PROXY`, error);
        }
        return this.next!();
    } */
}
