/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.tag.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TagRefGwtSerDer implements GwtSerDer<net.bluemind.tag.api.TagRef> {

	public TagRefGwtSerDer( ) {
	}

	@Override
	public net.bluemind.tag.api.TagRef deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.tag.api.TagRef ret = new net.bluemind.tag.api.TagRef();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.tag.api.TagRef ret, JSONObject json) {
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue itemUidJSON = json.get("itemUid");
		ret.itemUid =  GwtSerDerUtils.STRING.deserialize(itemUidJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue colorJSON = json.get("color");
		ret.color =  GwtSerDerUtils.STRING.deserialize(colorJSON);
	}

	public void deserializeTo(net.bluemind.tag.api.TagRef ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("containerUid")) {
			JSONValue containerUidJSON = json.get("containerUid");
			ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		}
		if (!childPropertiesToIgnore.contains("itemUid")) {
			JSONValue itemUidJSON = json.get("itemUid");
			ret.itemUid =  GwtSerDerUtils.STRING.deserialize(itemUidJSON);
		}
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("color")) {
			JSONValue colorJSON = json.get("color");
			ret.color =  GwtSerDerUtils.STRING.deserialize(colorJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.tag.api.TagRef o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.tag.api.TagRef o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("itemUid",  GwtSerDerUtils.STRING.serialize( o.itemUid ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("color",  GwtSerDerUtils.STRING.serialize( o.color ));
	}

	public void serializeTo(net.bluemind.tag.api.TagRef o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("containerUid")) {
			ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		}
		if (!childPropertiesToIgnore.contains("itemUid")) {
			ret.put("itemUid",  GwtSerDerUtils.STRING.serialize( o.itemUid ));
		}
		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("color")) {
			ret.put("color",  GwtSerDerUtils.STRING.serialize( o.color ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}