package net.bluemind.addressbook.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.addressbook.api.IAddressBookAsync.class)
public interface IAddressBookPromise  {

	CompletableFuture<java.util.List<java.lang.String>> allUids();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<Void> copy(java.util.List<java.lang.String> uids, java.lang.String destContainerUid);

	CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0);

	CompletableFuture<Void> create(java.lang.String uid, net.bluemind.addressbook.api.VCard card);

	CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id, net.bluemind.addressbook.api.VCard arg1);

	CompletableFuture<Void> delete(java.lang.String uid);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<Void> deletePhoto(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> getCompleteById(long id);

	CompletableFuture<byte[]> getIcon(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>> getInfo(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> getLight(java.lang.String uid);

	CompletableFuture<byte[]> getPhoto(java.lang.String uid);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<Void> move(java.util.List<java.lang.String> uids, java.lang.String destContainerUid);

	CompletableFuture<Void> multipleDeleteById(java.util.List<java.lang.Long> arg0, java.lang.Boolean bypassDeletedItems);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>> multipleGet(java.util.List<java.lang.String> uids);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>>> range(java.lang.Integer offset, java.lang.Integer size);

	CompletableFuture<Void> reset();

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>>> search(net.bluemind.addressbook.api.VCardQuery query);

	CompletableFuture<Void> setPhoto(java.lang.String uid, byte[] photo);

	CompletableFuture<java.util.List<java.lang.Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<java.util.List<java.lang.String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> sync(java.lang.Long since, net.bluemind.addressbook.api.VCardChanges changes);

	CompletableFuture<Void> touch(java.lang.String uid);

	CompletableFuture<Void> update(java.lang.String uid, net.bluemind.addressbook.api.VCard card);

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.addressbook.api.VCard arg1);

	CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.addressbook.api.VCardChanges changes);

}