/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2022
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keycloak.api;

import java.util.List;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.task.api.TaskRef;

@BMApi(version = "3", internal = true)
@Path("/keycloak")
public interface IKeycloakAdmin {

	@GET
	public List<Realm> allRealms() throws ServerFault;

	@GET
	@Path("{domainUid}")
	public Realm getRealm(@PathParam(value = "domainUid") String domainUid) throws ServerFault;

	@PUT
	@Path("{domainUid}")
	public void createRealm(@PathParam(value = "domainUid") String domainUid) throws ServerFault;

	@DELETE
	@Path("{domainUid}")
	public void deleteRealm(@PathParam(value = "domainUid") String domainUid) throws ServerFault;

	@POST
	@Path("{domainUid}")
	public TaskRef initForDomain(@PathParam(value = "domainUid") String domainUid,
			@QueryParam(value = "deleteFirst") Boolean deleteFirst) throws ServerFault;

	@POST
	@Path("_reconfigure")
	public TaskRef reconfigure() throws ServerFault;

}
