/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardChangesGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCardChanges> {

	public VCardChangesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCardChanges deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCardChanges ret = new net.bluemind.addressbook.api.VCardChanges();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardChanges ret, JSONObject json) {
		JSONValue addJSON = json.get("add");
		ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemAddGwtSerDer()).deserialize(addJSON);
		JSONValue modifyJSON = json.get("modify");
		ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardChanges ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("add")) {
			JSONValue addJSON = json.get("add");
			ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemAddGwtSerDer()).deserialize(addJSON);
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			JSONValue modifyJSON = json.get("modify");
			ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			JSONValue deleteJSON = json.get("delete");
			ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCardChanges o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardChanges o, JSONObject ret) {

		ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemAddGwtSerDer()).serialize( o.add ));
		ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemModifyGwtSerDer()).serialize( o.modify ));
		ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemDeleteGwtSerDer()).serialize( o.delete ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardChanges o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("add")) {
			ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemAddGwtSerDer()).serialize( o.add ));
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemModifyGwtSerDer()).serialize( o.modify ));
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardChangesItemDeleteGwtSerDer()).serialize( o.delete ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}