/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.addressbook.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsCertInfoCertUsage extends JavaScriptObject {

	protected JsCertInfoCertUsage() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsCertInfoCertUsage digitalSignature()
	/*-{
		return "digitalSignature";
	}-*/;

	public static final native JsCertInfoCertUsage nonRepudiation()
	/*-{
		return "nonRepudiation";
	}-*/;

	public static final native JsCertInfoCertUsage keyEncipherment()
	/*-{
		return "keyEncipherment";
	}-*/;

	public static final native JsCertInfoCertUsage dataEncipherment()
	/*-{
		return "dataEncipherment";
	}-*/;

	public static final native JsCertInfoCertUsage keyAgreement()
	/*-{
		return "keyAgreement";
	}-*/;

	public static final native JsCertInfoCertUsage keyCertSign()
	/*-{
		return "keyCertSign";
	}-*/;

	public static final native JsCertInfoCertUsage cRLSign()
	/*-{
		return "cRLSign";
	}-*/;

	public static final native JsCertInfoCertUsage encipherOnly()
	/*-{
		return "encipherOnly";
	}-*/;

	public static final native JsCertInfoCertUsage decipherOnly()
	/*-{
		return "decipherOnly";
	}-*/;

	public static final JsCertInfoCertUsage create(net.bluemind.addressbook.api.CertInfo.CertUsage value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case digitalSignature:
				return digitalSignature();
			case nonRepudiation:
				return nonRepudiation();
			case keyEncipherment:
				return keyEncipherment();
			case dataEncipherment:
				return dataEncipherment();
			case keyAgreement:
				return keyAgreement();
			case keyCertSign:
				return keyCertSign();
			case cRLSign:
				return cRLSign();
			case encipherOnly:
				return encipherOnly();
			case decipherOnly:
				return decipherOnly();
			default:
				return null;
			}
		}
	}
}