/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class AddressBooksSockJsEndpoint implements net.bluemind.addressbook.api.IAddressBooksAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public AddressBooksSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/addressbooks";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public AddressBooksSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void findCertsByEmail(String email, final AsyncHandler<List<net.bluemind.addressbook.api.CertInfo>> handler) {
		String postUri = "/_findCertsByEmail";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", URL.encodeQueryString(""+email));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.addressbook.api.CertInfo>>(handler) {
					@Override
			protected List<net.bluemind.addressbook.api.CertInfo> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void findUidsByEmail(String email, final AsyncHandler<List<String>> handler) {
		String postUri = "/_findUidsByEmail";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( email);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void search(net.bluemind.addressbook.api.VCardQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.addressbook.api.gwt.serder.VCardQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>>>(handler) {
					@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardInfoGwtSerDer())).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.addressbook.api.IAddressBooksPromise promiseApi() {
		return new AddressBooksEndpointPromise(this);
	}

}
