/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerChangelogGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerChangelog> {

	public ContainerChangelogGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerChangelog deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerChangelog ret = new net.bluemind.core.container.model.ContainerChangelog();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerChangelog ret, JSONObject json) {
		JSONValue entriesJSON = json.get("entries");
		ret.entries =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryGwtSerDer()).deserialize(entriesJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerChangelog ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("entries")) {
			JSONValue entriesJSON = json.get("entries");
			ret.entries =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryGwtSerDer()).deserialize(entriesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerChangelog o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerChangelog o, JSONObject ret) {

		ret.put("entries",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryGwtSerDer()).serialize( o.entries ));
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerChangelog o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("entries")) {
			ret.put("entries",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryGwtSerDer()).serialize( o.entries ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}