/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.model.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsItemValue<T extends JavaScriptObject> extends JavaScriptObject {

	protected JsItemValue() {}

	public final native T getValue()
	/*-{
	return this["value"];
	}-*/;

	public final native void setValue(T value)
	/*-{
       this["value"] = value;
	}-*/;

	public final native String getUid()
	/*-{
	return this["uid"];
	}-*/;

	public final native void setUid(String uid)
	/*-{
       this["uid"] = uid;
	}-*/;

	public final native java.lang.Long getInternalId()
	/*-{
	return this["internalId"];
	}-*/;

	public final native void setInternalId(java.lang.Long internalId)
	/*-{
       this["internalId"] = internalId;
	}-*/;

	public final native java.lang.Long getVersion()
	/*-{
	return this["version"];
	}-*/;

	public final native void setVersion(java.lang.Long version)
	/*-{
       this["version"] = version;
	}-*/;

	public final native String getDisplayName()
	/*-{
	return this["displayName"];
	}-*/;

	public final native void setDisplayName(String displayName)
	/*-{
       this["displayName"] = displayName;
	}-*/;

	public final native String getExternalId()
	/*-{
	return this["externalId"];
	}-*/;

	public final native void setExternalId(String externalId)
	/*-{
       this["externalId"] = externalId;
	}-*/;

	public final native String getCreatedBy()
	/*-{
	return this["createdBy"];
	}-*/;

	public final native void setCreatedBy(String createdBy)
	/*-{
       this["createdBy"] = createdBy;
	}-*/;

	public final native String getUpdatedBy()
	/*-{
	return this["updatedBy"];
	}-*/;

	public final native void setUpdatedBy(String updatedBy)
	/*-{
       this["updatedBy"] = updatedBy;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getCreated()
	/*-{
       if(this["created"]) {
          return new Date(this["created"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setCreated(com.google.gwt.core.client.JsDate created)
	/*-{
       this["created"] =  ( created != null) ? created.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getUpdated()
	/*-{
       if(this["updated"]) {
          return new Date(this["updated"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setUpdated(com.google.gwt.core.client.JsDate updated)
	/*-{
       this["updated"] =  ( updated != null) ? updated.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.core.container.model.gwt.js.JsItemFlag> getFlags()
	/*-{
	return this["flags"];
	}-*/;

	public final native void setFlags(com.google.gwt.core.client.JsArray<net.bluemind.core.container.model.gwt.js.JsItemFlag> flags)
	/*-{
       this["flags"] = flags;
	}-*/;

	public static native  JsItemValue create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}