/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.model.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsContainerSyncStatus extends JavaScriptObject {

	protected JsContainerSyncStatus() {}

	public final native net.bluemind.core.commons.gwt.JsMapStringString getSyncTokens()
	/*-{
	return this["syncTokens"];
	}-*/;

	public final native void setSyncTokens(net.bluemind.core.commons.gwt.JsMapStringString syncTokens)
	/*-{
       this["syncTokens"] = syncTokens;
	}-*/;

	public final native Long getNextSync()
	/*-{
	return this["nextSync"];
	}-*/;

	public final native void setNextSync(Long nextSync)
	/*-{
       this["nextSync"] = nextSync;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getLastSync()
	/*-{
       if(this["lastSync"]) {
          return new Date(this["lastSync"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setLastSync(com.google.gwt.core.client.JsDate lastSync)
	/*-{
       this["lastSync"] =  ( lastSync != null) ? lastSync.getTime() : null;
	}-*/;

	public final native net.bluemind.core.container.model.gwt.js.JsContainerSyncStatusStatus getSyncStatus()
	/*-{
	return this["syncStatus"];
	}-*/;

	public final native void setSyncStatus(net.bluemind.core.container.model.gwt.js.JsContainerSyncStatusStatus syncStatus)
	/*-{
       this["syncStatus"] = syncStatus;
	}-*/;

	public final native String getSyncStatusInfo()
	/*-{
	return this["syncStatusInfo"];
	}-*/;

	public final native void setSyncStatusInfo(String syncStatusInfo)
	/*-{
       this["syncStatusInfo"] = syncStatusInfo;
	}-*/;

	public static native  JsContainerSyncStatus create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}