/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.common.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SendingAsGwtSerDer implements GwtSerDer<net.bluemind.mailflow.common.api.SendingAs> {

	public SendingAsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.common.api.SendingAs deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.common.api.SendingAs ret = new net.bluemind.mailflow.common.api.SendingAs();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.SendingAs ret, JSONObject json) {
		JSONValue senderJSON = json.get("sender");
		ret.sender =  GwtSerDerUtils.STRING.deserialize(senderJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.SendingAs ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("sender")) {
			JSONValue senderJSON = json.get("sender");
			ret.sender =  GwtSerDerUtils.STRING.deserialize(senderJSON);
		}
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailflow.common.api.SendingAs o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.common.api.SendingAs o, JSONObject ret) {

		ret.put("sender",  GwtSerDerUtils.STRING.serialize( o.sender ));
		ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
	}

	public void serializeTo(net.bluemind.mailflow.common.api.SendingAs o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("sender")) {
			ret.put("sender",  GwtSerDerUtils.STRING.serialize( o.sender ));
		}
		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}