/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.common.context;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ContextAccessProvider {

	private static final ContextAccess loaded = load();

	private ContextAccessProvider() {

	}

	private static ContextAccess load() {
		List<ContextAccess> list = loadExtensions("net.bluemind.common.context", "provider", "provider", "impl");
		return list.getFirst();
	}

	public static ContextAccess get() {
		return loaded;
	}

	public static <T> List<T> loadExtensions(String pluginId, String pointName, String element, String attribute) {
		List<T> factories = new LinkedList<>();
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		Objects.requireNonNull(registry, "OSGi registry is null");
		IExtensionPoint point = registry.getExtensionPoint(pluginId, pointName);
		if (point == null) {
			return factories;
		}
		IExtension[] extensions = point.getExtensions();

		for (IExtension ie : extensions) {
			for (IConfigurationElement e : ie.getConfigurationElements()) {
				if (element.equals(e.getName())) {
					try {
						@SuppressWarnings("unchecked")
						T factory = (T) e.createExecutableExtension(attribute);
						factories.add(factory);
					} catch (CoreException ce) {
						ce.printStackTrace();
					}

				}
			}
		}
		return factories;
	}
}
